/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal.processor;

import cc.dsnb.bedrockplayersupport.dazzleconf.annote.CollectionSize;
import cc.dsnb.bedrockplayersupport.dazzleconf.annote.IntegerRange;
import cc.dsnb.bedrockplayersupport.dazzleconf.annote.NumericRange;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.BadValueException;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.InvalidConfigException;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfEntry;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.error.UserError;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.processor.ProcessorBase;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.CollectionKind;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.CollectionReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.MapReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.ReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.SimpleSubSectionReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.SubSectionCollectionReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.SubSectionMapReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.ImmutableCollections;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.UncheckedInvalidConfigException;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.FlexibleType;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.FlexibleTypeFunction;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.FlexibleTypeMapEntryFunction;
import java.util.Collection;
import java.util.Map;

class Composition {
    private final ProcessorBase<?> processor;
    private final ConfEntry entry;
    private final Object preValue;
    private final FlexibleType flexType;

    Composition(ProcessorBase<?> processor, ConfEntry entry, Object preValue, FlexibleType flexType) {
        this.processor = processor;
        this.entry = entry;
        this.preValue = preValue;
        this.flexType = flexType;
    }

    Object processObject() throws InvalidConfigException {
        ReturnType<?> returnType = this.entry.returnType();
        if (returnType instanceof SimpleSubSectionReturnType) {
            return this.processor.createNested(this.entry, (SimpleSubSectionReturnType)returnType, this.preValue);
        }
        if (returnType instanceof CollectionReturnType) {
            return this.getCollection((CollectionReturnType)returnType);
        }
        if (returnType instanceof MapReturnType) {
            return this.getMap((MapReturnType)returnType);
        }
        Class<?> goal = returnType.typeInfo().rawType();
        if (goal == Integer.TYPE || goal == Integer.class) {
            return this.getAsNumber().intValue();
        }
        if (goal == Long.TYPE || goal == Long.class) {
            return this.getAsNumber().longValue();
        }
        if (goal == Short.TYPE || goal == Short.class) {
            return this.getAsNumber().shortValue();
        }
        if (goal == Byte.TYPE || goal == Byte.class) {
            return this.getAsNumber().byteValue();
        }
        if (goal == Double.TYPE || goal == Double.class) {
            return this.getAsNumber().doubleValue();
        }
        if (goal == Float.TYPE || goal == Float.class) {
            return Float.valueOf(this.getAsNumber().floatValue());
        }
        return this.flexType.getObject(goal);
    }

    private <E, R extends Collection<E>> R getCollection(CollectionReturnType<E, R> returnType) throws InvalidConfigException {
        Collection<Object> collection;
        FlexibleTypeFunction<Object> function;
        if (returnType instanceof SubSectionCollectionReturnType) {
            SubSectionCollectionReturnType subSectionReturnType = (SubSectionCollectionReturnType)returnType;
            function = element -> {
                try {
                    return this.processor.createNested(this.entry, subSectionReturnType, element.getObject(Object.class));
                }
                catch (InvalidConfigException ex) {
                    throw new UncheckedInvalidConfigException(ex);
                }
            };
        } else {
            Class rawElementType = returnType.elementTypeInfo().rawType();
            function = element -> element.getObject(rawElementType);
        }
        try {
            collection = this.getCollectionUsing(returnType.collectionKind(), function);
        }
        catch (UncheckedInvalidConfigException ex) {
            throw ex.getCause();
        }
        this.checkSize(collection.size());
        Collection<Object> castedCollection = collection;
        return (R)castedCollection;
    }

    private <E> Collection<E> getCollectionUsing(CollectionKind kind, FlexibleTypeFunction<E> function) throws BadValueException {
        switch (kind) {
            case COLLECTION: {
                return this.flexType.getCollection(function);
            }
            case SET: {
                return this.flexType.getSet(function);
            }
            case LIST: {
                return this.flexType.getList(function);
            }
        }
        throw new IllegalArgumentException("Internal error: Unknown collection kind " + (Object)((Object)kind));
    }

    private <K, V> Map<K, V> getMap(MapReturnType<K, V> returnType) throws InvalidConfigException {
        Map map;
        FlexibleTypeMapEntryFunction function;
        Class rawKeyType = returnType.keyTypeInfo().rawType();
        if (returnType instanceof SubSectionMapReturnType) {
            SubSectionMapReturnType subSectionReturnType = (SubSectionMapReturnType)returnType;
            function = (flexibleKey, flexibleValue) -> {
                Object value;
                Object key = flexibleKey.getObject(rawKeyType);
                try {
                    value = this.processor.createNested(this.entry, subSectionReturnType, flexibleValue.getObject(Object.class));
                }
                catch (InvalidConfigException ex) {
                    throw new UncheckedInvalidConfigException(ex);
                }
                return ImmutableCollections.mapEntryOf(key, value);
            };
        } else {
            Class rawValueType = returnType.valueTypeInfo().rawType();
            function = (flexibleKey, flexibleValue) -> {
                Object key = flexibleKey.getObject(rawKeyType);
                Object value = flexibleValue.getObject(rawValueType);
                return ImmutableCollections.mapEntryOf(key, value);
            };
        }
        try {
            map = this.flexType.getMap(function);
        }
        catch (UncheckedInvalidConfigException ex) {
            throw ex.getCause();
        }
        this.checkSize(map.size());
        return map;
    }

    private void checkSize(int size) throws BadValueException {
        CollectionSize sizing = this.entry.getMethod().getAnnotation(CollectionSize.class);
        if (sizing != null) {
            if (size < sizing.min()) {
                throw this.flexType.badValueExceptionBuilder().message(UserError.sizeTooSmall(size, sizing.min())).build();
            }
            if (size > sizing.max()) {
                throw this.flexType.badValueExceptionBuilder().message(UserError.sizeTooBig(size, sizing.max())).build();
            }
        }
    }

    private Number getAsNumber() throws BadValueException {
        Number number = this.flexType.getObject(Number.class);
        this.checkRange(number);
        return number;
    }

    private void checkRange(Number number) throws BadValueException {
        IntegerRange intRange;
        NumericRange numericRange = this.entry.getMethod().getAnnotation(NumericRange.class);
        if (numericRange != null) {
            double asDouble = number.doubleValue();
            if (asDouble < numericRange.min()) {
                throw this.flexType.badValueExceptionBuilder().message(UserError.sizeTooSmall(asDouble, numericRange.min())).build();
            }
            if (asDouble > numericRange.max()) {
                throw this.flexType.badValueExceptionBuilder().message(UserError.sizeTooBig(asDouble, numericRange.max())).build();
            }
        }
        if ((intRange = this.entry.getMethod().getAnnotation(IntegerRange.class)) != null) {
            long asLong = number.longValue();
            if (asLong < intRange.min()) {
                throw this.flexType.badValueExceptionBuilder().message(UserError.sizeTooSmall(asLong, intRange.min())).build();
            }
            if (asLong > intRange.max()) {
                throw this.flexType.badValueExceptionBuilder().message(UserError.sizeTooBig(asLong, intRange.max())).build();
            }
        }
    }
}

