/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal.processor;

import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.ImmutableCollections;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

class ConfigInvocationHandler
implements InvocationHandler {
    private final Map<String, Object> configMap;

    ConfigInvocationHandler(Map<String, Object> configMap) {
        this.configMap = ImmutableCollections.mapOf(configMap);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            if (method.getName().equals("equals")) {
                return ConfigInvocationHandler.implementEquals(proxy, args2[0]);
            }
            return this.invokeMethodOnSelf(method, args2);
        }
        assert (args2 == null) : Arrays.deepToString(args2);
        return this.configMap.get(method.getName());
    }

    private Object invokeMethodOnSelf(Method method, Object[] args2) throws Throwable {
        try {
            return method.invoke((Object)this, args2);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                throw cause;
            }
            throw ex;
        }
    }

    private static boolean implementEquals(Object ourProxy, Object theirConfig) {
        return ourProxy == theirConfig;
    }

    public String toString() {
        return "ConfigInvocationHandler [configMap=" + this.configMap + "]";
    }
}

