/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal.processor;

import cc.dsnb.bedrockplayersupport.dazzleconf.ConfigurationOptions;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.BadValueException;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.ImproperEntryException;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.InvalidConfigException;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfEntry;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfigurationDefinition;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.NestedMapHelper;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.error.ElementaryType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.error.UserError;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.processor.ProcessorBase;
import java.util.Map;

public class MapProcessor<C>
extends ProcessorBase<C> {
    private final NestedMapHelper mapHelper;

    public MapProcessor(ConfigurationOptions options, ConfigurationDefinition<C> definition, Map<String, Object> sourceMap, C auxiliaryValues) {
        this(options, definition, new NestedMapHelper(sourceMap), auxiliaryValues);
    }

    private MapProcessor(ConfigurationOptions options, ConfigurationDefinition<C> definition, NestedMapHelper mapHelper, C auxiliaryValues) {
        super(options, definition, auxiliaryValues);
        this.mapHelper = mapHelper;
    }

    @Override
    <N> N createChildConfig(ConfigurationOptions options, ConfigurationDefinition<N> childDefinition, String key, Object preValue, N nestedAuxiliaryValues) throws InvalidConfigException {
        if (!(preValue instanceof Map)) {
            throw new BadValueException.Builder().key(key).message(UserError.wrongType(ElementaryType.SECTION, preValue)).build();
        }
        Map childMap = (Map)preValue;
        return this.createFromProcessor(new MapProcessor<N>(options, childDefinition, childMap, nestedAuxiliaryValues));
    }

    @Override
    Object getValueFromSources(ConfEntry entry) throws ImproperEntryException {
        return this.mapHelper.get(entry.getKey());
    }
}

