/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal.type;

import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.AccessChecking;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.ImmutableCollections;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;

public final class TypeInfo<T> {
    private final Class<T> rawType;
    private final List<Annotation> annotations;
    private final List<TypeInfo<?>> arguments;

    TypeInfo(Class<T> rawType, List<Annotation> annotations, List<TypeInfo<?>> arguments) {
        this.rawType = Objects.requireNonNull(rawType, "raw type");
        this.annotations = ImmutableCollections.listOf(annotations);
        this.arguments = ImmutableCollections.listOf(arguments);
    }

    public Class<T> rawType() {
        return this.rawType;
    }

    public boolean isTypeAccessible() {
        return AccessChecking.isAccessible(this.rawType);
    }

    public List<Annotation> annotations() {
        return this.annotations;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (this.rawType().isAnnotationPresent(annotationClass)) {
            return true;
        }
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public List<TypeInfo<?>> arguments() {
        return this.arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeInfo typeInfo = (TypeInfo)o;
        return this.rawType.equals(typeInfo.rawType) && this.annotations.equals(typeInfo.annotations) && this.arguments.equals(typeInfo.arguments);
    }

    public int hashCode() {
        int result = this.rawType.hashCode();
        result = 31 * result + this.annotations.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    public String toString() {
        return "TypeInfo{rawType=" + this.rawType + ", annotations=" + this.annotations + ", arguments=" + this.arguments + '}';
    }
}

