/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal.type;

import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.TypeInfo;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.ImmutableCollections;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;

public class TypeInfoCreation {
    private final AnnotatedType annotatedType;

    public TypeInfoCreation(AnnotatedType annotatedType) {
        this.annotatedType = annotatedType;
    }

    public <T> TypeInfo<T> create(Class<T> rawType) {
        return new TypeInfo<T>(rawType, ImmutableCollections.listOf(this.annotatedType.getAnnotations()), this.getArguments());
    }

    private List<TypeInfo<?>> getArguments() {
        if (!(this.annotatedType instanceof AnnotatedParameterizedType)) {
            return ImmutableCollections.emptyList();
        }
        AnnotatedParameterizedType paramAnnotatedType = (AnnotatedParameterizedType)this.annotatedType;
        AnnotatedType[] typeArguments = paramAnnotatedType.getAnnotatedActualTypeArguments();
        ArrayList arguments = new ArrayList(typeArguments.length);
        for (AnnotatedType typeArgument : typeArguments) {
            arguments.add(new TypeInfoCreation(typeArgument).create());
        }
        return arguments;
    }

    private TypeInfo<?> create() {
        return this.create(TypeInfoCreation.getRawType(this.annotatedType.getType()));
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return (Class)rawType;
        }
        if (type instanceof WildcardType) {
            return TypeInfoCreation.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof TypeVariable) {
            return TypeInfoCreation.getRawType(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            Class<?> rawComponentType = TypeInfoCreation.getRawType(((GenericArrayType)type).getGenericComponentType());
            Object array = Array.newInstance(rawComponentType, 0);
            return array.getClass();
        }
        return Object.class;
    }
}

