/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal.util;

import cc.dsnb.bedrockplayersupport.dazzleconf.error.IllDefinedConfigException;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.DefaultMethodProvider;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.Java8DefaultMethodProvider;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.jdk11.Java11DefaultMethodProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class MethodUtil {
    private static final DefaultMethodProvider DEFAULT_METHOD_PROVIDER = MethodUtil.createDefaultMethodProvider();

    private MethodUtil() {
    }

    public static String getQualifiedName(Method method) {
        return method.getDeclaringClass().getName() + "#" + method.getName();
    }

    public static boolean isDefault(Method method) {
        boolean isDefault;
        int modifiers = method.getModifiers();
        boolean bl = isDefault = (modifiers & 0x409) == 1;
        assert (isDefault == method.isDefault());
        return isDefault;
    }

    public static MethodHandle createDefaultMethodHandle(Method method) {
        try {
            return DEFAULT_METHOD_PROVIDER.getMethodHandle(method);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new IllDefinedConfigException("Unable to generate default method accessor for " + MethodUtil.getQualifiedName(method), ex);
        }
    }

    private static DefaultMethodProvider createDefaultMethodProvider() {
        try {
            MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            return new Java11DefaultMethodProvider();
        }
        catch (NoSuchMethodException nsme) {
            return new Java8DefaultMethodProvider();
        }
    }
}

