/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.serialiser;

import cc.dsnb.bedrockplayersupport.dazzleconf.error.BadValueException;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.Decomposer;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.FlexibleType;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.ValueSerialiser;
import java.net.MalformedURLException;
import java.net.URL;

public final class URLValueSerialiser
implements ValueSerialiser<URL> {
    private static final URLValueSerialiser INSTANCE = new URLValueSerialiser();

    private URLValueSerialiser() {
    }

    public static URLValueSerialiser getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<URL> getTargetClass() {
        return URL.class;
    }

    @Override
    public URL deserialise(FlexibleType flexibleType) throws BadValueException {
        URL url;
        String value = flexibleType.getString();
        try {
            url = new URL(value);
        }
        catch (MalformedURLException ex) {
            throw flexibleType.badValueExceptionBuilder().message("malformed URL " + value).cause(ex).build();
        }
        return url;
    }

    public String serialise(URL value, Decomposer decomposer) {
        return value.toExternalForm();
    }
}

