/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.serialiser;

import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.ImmutableCollections;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.ValueSerialiser;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ValueSerialiserMap {
    private final Map<Class<?>, ValueSerialiser<?>> map;
    private static final ValueSerialiserMap EMPTY = new ValueSerialiserMap();

    private ValueSerialiserMap() {
        this.map = ImmutableCollections.emptyMap();
    }

    private ValueSerialiserMap(Map<Class<?>, ValueSerialiser<?>> map) {
        this.map = ImmutableCollections.mapOf(map);
    }

    private static ValueSerialiserMap fromMap(Map<Class<?>, ValueSerialiser<?>> map) {
        if (map.isEmpty()) {
            return EMPTY;
        }
        return new ValueSerialiserMap(map);
    }

    public static ValueSerialiserMap of(Collection<? extends ValueSerialiser<?>> serialisers) {
        HashMap map = new HashMap();
        for (ValueSerialiser<?> serialiser : serialisers) {
            Objects.requireNonNull(serialiser, "serialiser");
            ValueSerialiser<?> previous = map.putIfAbsent(serialiser.getTargetClass(), serialiser);
            if (previous == null) continue;
            throw new IllegalArgumentException("ValueSerialiser " + serialiser + " conflicts with " + previous);
        }
        return ValueSerialiserMap.fromMap(map);
    }

    public static ValueSerialiserMap of(Map<Class<?>, ? extends ValueSerialiser<?>> serialisers) {
        HashMap map = new HashMap(serialisers);
        for (Map.Entry entry : map.entrySet()) {
            Class actualKey = (Class)entry.getKey();
            ValueSerialiser serialiser = (ValueSerialiser)entry.getValue();
            Objects.requireNonNull(serialiser, "serialiser");
            Class expectedKey = serialiser.getTargetClass();
            if (actualKey == expectedKey) continue;
            throw new IllegalArgumentException("ValueSerialiser " + serialiser + " is at a mismatched key, expected " + expectedKey + " but got " + actualKey);
        }
        return ValueSerialiserMap.fromMap(map);
    }

    public static ValueSerialiserMap empty() {
        return EMPTY;
    }

    @Deprecated
    public <T> ValueSerialiser<T> getSerialiser(Class<T> type) {
        return this.getSerialiserFor(type).orElse(null);
    }

    public <T> Optional<ValueSerialiser<T>> getSerialiserFor(Class<T> type) {
        ValueSerialiser<?> serialiser = this.map.get(type);
        return Optional.ofNullable(serialiser);
    }

    public Map<Class<?>, ValueSerialiser<?>> asMap() {
        return this.map;
    }

    public String toString() {
        return "ValueSerialiserMap [map=" + this.map + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.map.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueSerialiserMap)) {
            return false;
        }
        ValueSerialiserMap other = (ValueSerialiserMap)object;
        return this.map.equals(other.map);
    }
}

