/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.manager;

import cc.dsnb.bedrockplayersupport.BedrockPlayerSupport;
import cc.dsnb.bedrockplayersupport.dazzleconf.ConfigurationFactory;
import cc.dsnb.bedrockplayersupport.dazzleconf.ConfigurationOptions;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.ConfigFormatSyntaxException;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.InvalidConfigException;
import cc.dsnb.bedrockplayersupport.dazzleconf.ext.snakeyaml.CommentMode;
import cc.dsnb.bedrockplayersupport.dazzleconf.ext.snakeyaml.SnakeYamlConfigurationFactory;
import cc.dsnb.bedrockplayersupport.dazzleconf.ext.snakeyaml.SnakeYamlOptions;
import cc.dsnb.bedrockplayersupport.dazzleconf.helper.ConfigurationHelper;
import cc.dsnb.bedrockplayersupport.dazzleconf.sorter.AnnotationBasedSorter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \r*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\rB\u0017\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u000b\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u000e"}, d2={"Lcc/dsnb/bedrockplayersupport/manager/ConfigManager;", "C", "", "configHelper", "Lcc/dsnb/bedrockplayersupport/dazzleconf/helper/ConfigurationHelper;", "<init>", "(Lspace/arim/dazzleconf/helper/ConfigurationHelper;)V", "configData", "Ljava/lang/Object;", "reloadConfig", "", "getConfigData", "()Ljava/lang/Object;", "Companion", "BedrockPlayerSupport"})
public final class ConfigManager<C> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigurationHelper<C> configHelper;
    @Nullable
    private volatile C configData;

    private ConfigManager(ConfigurationHelper<C> configHelper) {
        this.configHelper = configHelper;
    }

    public final void reloadConfig() {
        try {
            this.configData = this.configHelper.reloadConfigData();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (ConfigFormatSyntaxException ex) {
            this.configData = this.configHelper.getFactory().loadDefaults();
            BedrockPlayerSupport.Companion.getInstance().getLogger().severe("\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u9519\u8bef, \u8bf7\u68c0\u67e5\u4f60\u7684\u914d\u7f6e\u6587\u4ef6 | The yaml syntax in your configuration is invalid");
            ex.printStackTrace();
        }
        catch (InvalidConfigException ex) {
            this.configData = this.configHelper.getFactory().loadDefaults();
            BedrockPlayerSupport.Companion.getInstance().getLogger().severe("\u914d\u7f6e\u6587\u4ef6\u67d0\u4e2a\u952e\u503c\u65e0\u6548, \u8bf7\u68c0\u67e5\u4f60\u7684\u914d\u7f6e\u6587\u4ef6 | One of the values in your configuration is not valid");
            ex.printStackTrace();
        }
    }

    public final C getConfigData() {
        C c = this.configData;
        if (c == null) {
            throw new IllegalStateException("\u914d\u7f6e\u6587\u4ef6\u8fd8\u6ca1\u6709\u52a0\u8f7d | Configuration has not been loaded yet");
        }
        C configData = c;
        return configData;
    }

    public /* synthetic */ ConfigManager(ConfigurationHelper configHelper, DefaultConstructorMarker $constructor_marker) {
        this(configHelper);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\f\u00a8\u0006\r"}, d2={"Lcc/dsnb/bedrockplayersupport/manager/ConfigManager$Companion;", "", "<init>", "()V", "create", "Lcc/dsnb/bedrockplayersupport/manager/ConfigManager;", "C", "configFolder", "Ljava/nio/file/Path;", "fileName", "", "configClass", "Ljava/lang/Class;", "BedrockPlayerSupport"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <C> ConfigManager<C> create(@Nullable Path configFolder, @Nullable String fileName, @Nullable Class<C> configClass) {
            SnakeYamlOptions yamlOptions = new SnakeYamlOptions.Builder().commentMode(CommentMode.alternativeWriter()).build();
            ConfigurationFactory<C> configFactory = SnakeYamlConfigurationFactory.create(configClass, new ConfigurationOptions.Builder().sorter(new AnnotationBasedSorter()).build(), yamlOptions);
            return new ConfigManager(new ConfigurationHelper<C>(configFolder, fileName, configFactory), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

