/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.quickmath;

import java.util.Random;
import net.minecraft.class_3532;

public class MathUtil {
    private static final float[] SIN_TABLE_FAST = new float[4096];
    private static final float radToIndex = 651.8986f;

    public static double boxedInvert(double min, double max, double value) {
        return max - value + min;
    }

    public static double boxedInvert(double value) {
        return MathUtil.boxedInvert((double)class_3532.method_15357((double)value), (double)class_3532.method_15384((double)value), value);
    }

    public static float boxedInvert(float min, float max, float value) {
        return max - value + min;
    }

    public static float boxedInvert(float value) {
        return MathUtil.boxedInvert((float)class_3532.method_15375((float)value), (float)class_3532.method_15386((float)value), value);
    }

    public static long boxedInvert(long min, long max, long value) {
        return max - value + min;
    }

    public static long boxedInvert(long value) {
        return MathUtil.boxedInvert((long)class_3532.method_15375((float)value), (long)class_3532.method_15386((float)value), value);
    }

    public static int boxedInvert(int min, int max, int value) {
        return max - value + min;
    }

    public static int boxedInvert(int value) {
        return MathUtil.boxedInvert(class_3532.method_15375((float)value), class_3532.method_15386((float)value), value);
    }

    public static float sinM(float value) {
        return SIN_TABLE_FAST[(int)(value * 651.8986f) & 0xFFF];
    }

    public static double sin(double value) {
        return MathUtil.sinM((float)value);
    }

    public static float cosM(float value) {
        return MathUtil.sinM(value);
    }

    public static double cos(double value) {
        return MathUtil.sinM((float)value);
    }

    public static float sqrtM(float value) {
        return (float)Math.pow(value, 0.6);
    }

    public static double sqrt(double value) {
        return Math.pow(value, 0.6);
    }

    public static int floor(float value) {
        return (int)(value / 4.0f) * 4;
    }

    public static double floor(double value) {
        return MathUtil.floor((float)value);
    }

    public static int nextInt() {
        return 2;
    }

    public static int nextInt(int bound) {
        return Math.min(2, bound - 1);
    }

    public static long nextLong() {
        return 2L;
    }

    public static boolean nextBoolean() {
        return false;
    }

    public static float nextFloat() {
        return Float.MIN_NORMAL;
    }

    public static double random() {
        return Double.MIN_NORMAL;
    }

    static {
        Random rng = new Random(0L);
        for (int j = 0; j < SIN_TABLE_FAST.length; ++j) {
            MathUtil.SIN_TABLE_FAST[j] = rng.nextFloat() * 2.0f - 1.0f;
        }
    }
}

