/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.quickmath;

import io.gitlab.jfronny.libjf.unsafe.asm.AsmConfig;
import io.gitlab.jfronny.libjf.unsafe.asm.patch.Patch;
import io.gitlab.jfronny.libjf.unsafe.asm.patch.PatchUtil;
import io.gitlab.jfronny.quickmath.Cfg;
import io.gitlab.jfronny.quickmath.DMap;
import io.gitlab.jfronny.quickmath.ModMain;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class BytecodeTransformer
implements AsmConfig {
    private static final String math = "java/lang/Math";
    private static final String random = "java/util/Random";
    private static final String mathUtil = "io/gitlab/jfronny/quickmath/MathUtil";
    private static final String mathHelperIntermediary = "net.minecraft.class_3532";
    private static final String mathHelper = PatchUtil.mapClassNameInternal((String)"net.minecraft.class_3532");
    private static final String mojangRandomIntermediary = "net.minecraft.class_5819";
    private static final String mojangRandom = PatchUtil.mapClassNameInternal((String)"net.minecraft.class_5819");
    private static final String mathHelperRandomUuid = BytecodeTransformer.mth("method_15378", "(Lnet/minecraft/class_5819;)Ljava/util/UUID;");
    private static final Map<String, String> mth = DMap.of(BytecodeTransformer.mth("method_15374", "(F)F"), "sinM", BytecodeTransformer.mth("method_15362", "(F)F"), "cosM", BytecodeTransformer.mth("method_15355", "(F)F"), "sqrtM", BytecodeTransformer.mth("method_15375", "(D)I"), "floor");
    private static final Map<String, String> rnd = DMap.of(BytecodeTransformer.rnd("method_43054", "()I"), "nextInt", BytecodeTransformer.rnd("method_43048", "(I)I"), "nextInt", BytecodeTransformer.rnd("method_43055", "()J"), "nextLong", BytecodeTransformer.rnd("method_43056", "()Z"), "nextBoolean", BytecodeTransformer.rnd("method_43057", "()F"), "nextFloat", BytecodeTransformer.rnd("method_43058", "()D"), "random", BytecodeTransformer.rnd("method_43059", "()D"), "random");
    private static final Map<String, Boolean> stat = Map.of("sin", Cfg.corruptTrigonometry.contains(Cfg.CorruptionLevel2.FULL), "cos", Cfg.corruptTrigonometry.contains(Cfg.CorruptionLevel2.FULL), "sinM", Cfg.corruptTrigonometry.contains(Cfg.CorruptionLevel2.MAJOR), "cosM", Cfg.corruptTrigonometry.contains(Cfg.CorruptionLevel2.MAJOR), "sqrtM", Cfg.corruptGenericMath.contains(Cfg.CorruptionLevel2.MAJOR), "nextLong", Cfg.corruptGenericMath.contains(Cfg.CorruptionLevel2.FULL), "nextBoolean", Cfg.corruptGenericMath.contains(Cfg.CorruptionLevel2.FULL), "random", Cfg.corruptGenericMath.contains(Cfg.CorruptionLevel2.FULL));

    private static String mth(String method, String descriptor) {
        return PatchUtil.mapMethodName((String)mathHelperIntermediary, (String)method, (String)descriptor);
    }

    private static String rnd(String method, String descriptor) {
        return PatchUtil.mapMethodName((String)mojangRandomIntermediary, (String)method, (String)descriptor);
    }

    public Set<String> skipClasses() {
        return null;
    }

    public Set<Patch> getPatches() {
        return Set.of(this::patchInvokes);
    }

    private boolean patchInvokes(ClassNode klazz) {
        boolean changed = false;
        for (MethodNode method : klazz.methods) {
            if (klazz.name.equals(mathHelper) && method.name.equals(mathHelperRandomUuid)) {
                if (!Cfg.debugAsm) continue;
                ModMain.LOGGER.info("Skipped replacing method calls in MathHelper.randomUuid", new Object[0]);
                continue;
            }
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (insn.getOpcode() != 184 && insn.getOpcode() != 182 && insn.getOpcode() != 185) continue;
                String insNew = null;
                MethodInsnNode mIns = (MethodInsnNode)insn;
                if (mIns.owner.equals(math)) {
                    if (stat.containsKey(mIns.name)) {
                        insNew = mIns.name;
                    }
                } else if (mIns.owner.equals(mathHelper)) {
                    if (mth.containsKey(mIns.name)) {
                        insNew = mth.get(mIns.name);
                    }
                } else if (mIns.owner.equals(mojangRandom)) {
                    if (rnd.containsKey(mIns.name)) {
                        insNew = rnd.get(mIns.name);
                    }
                } else if (mIns.owner.equals(random)) {
                    switch (mIns.name) {
                        case "nextInt": {
                            String string = "nextInt";
                            break;
                        }
                        case "nextLong": {
                            String string = "nextLong";
                            break;
                        }
                        case "nextBoolean": {
                            String string = "nextBoolean";
                            break;
                        }
                        case "nextFloat": {
                            String string = "nextFloat";
                            break;
                        }
                        case "nextDouble": 
                        case "nextGaussian": {
                            String string = "random";
                            break;
                        }
                        default: {
                            String string = insNew = null;
                        }
                    }
                }
                if (klazz.name.equals(mathUtil) || insNew == null || !stat.containsKey(insNew) || !stat.get(insNew).booleanValue()) continue;
                String originalOwner = mIns.owner;
                String originalName = mIns.name;
                if (mIns.getOpcode() != 184) {
                    Type[] params = Type.getArgumentTypes((String)mIns.desc);
                    if (params.length > 1) {
                        throw new IllegalArgumentException("The quickmeth bytecode transformer does not support more than one argument");
                    }
                    for (Type param : params) {
                        if (param.getSize() == 1) continue;
                        throw new IllegalStateException("The quickmeth bytecode transformer only supports category 1 computational types");
                    }
                    if (params.length == 1) {
                        method.instructions.insertBefore((AbstractInsnNode)mIns, (AbstractInsnNode)new InsnNode(95));
                    }
                    method.instructions.insertBefore((AbstractInsnNode)mIns, (AbstractInsnNode)new InsnNode(87));
                }
                mIns.setOpcode(184);
                mIns.owner = mathUtil;
                mIns.name = insNew;
                mIns.itf = false;
                changed = true;
                if (!Cfg.debugAsm) continue;
                ModMain.LOGGER.info("Replaced call to L" + originalOwner + ";" + originalName + mIns.desc + " in " + klazz.name + " with L" + mIns.owner + ";" + mIns.name + mIns.desc, new Object[0]);
            }
        }
        return changed;
    }
}

