/*
 * Decompiled with CFR 0.152.
 */
package dev.neylz.gitpuller;

import dev.neylz.gitpuller.util.GitUtil;
import dev.neylz.gitpuller.util.ModConfig;
import dev.neylz.gitpuller.util.ModRegistries;
import dev.neylz.gitpuller.util.TokenManager;
import java.io.File;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitPuller
implements ModInitializer {
    public static final String MOD_ID = "gitpuller";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"gitpuller");

    public void onInitialize() {
        ModRegistries.registerAll();
        if (!ModConfig.isMonoRepo()) {
            LOGGER.info("GitPuller is running in multi repo mode (default)");
        } else {
            LOGGER.info("GitPuller is running in mono repo mode!");
            if (!GitUtil.URL_PATTERN.matcher(ModConfig.getMonoRepoUrl()).matches()) {
                LOGGER.error("Provided URL is invalid: {}", (Object)ModConfig.getMonoRepoUrl());
                System.exit(-1);
                return;
            }
            LOGGER.info("Using {} as the mono repo URL", (Object)ModConfig.getMonoRepoUrl());
            File dp = FabricLoader.getInstance().getConfigDir().getParent().resolve("world/datapacks/").toFile();
            if (!GitUtil.isGitRepoRemote(dp, ModConfig.getMonoRepoUrl())) {
                LOGGER.info("Datapacks folder does not tracks {}. Cloning mono repo into {}", (Object)ModConfig.getMonoRepoUrl(), (Object)dp.getAbsolutePath());
                if (dp.exists() && Objects.requireNonNull(dp.listFiles()).length > 0) {
                    LOGGER.error("Datapacks folder is not empty! Please remove all files from it before using monorepo mode.");
                    System.exit(-1);
                    return;
                }
                if (!dp.exists() && !dp.mkdirs()) {
                    LOGGER.error("Could not create datapacks folder! Please check your permissions.");
                    return;
                }
                try {
                    ((CloneCommand)Git.cloneRepository().setURI(ModConfig.getMonoRepoUrl()).setDirectory(dp).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(TokenManager.getInstance().getToken(), ""))).call();
                }
                catch (Exception e) {
                    LOGGER.error("Could not clone the mono repo! Please check your permissions.");
                    System.exit(-1);
                    return;
                }
                LOGGER.info("Successfully cloned monorepo into {}", (Object)dp.getAbsolutePath());
            }
        }
        LOGGER.info("GitPuller initialized!");
    }
}

