/*
 * Decompiled with CFR 0.152.
 */
package dev.neylz.gitpuller.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.jetbrains.annotations.NotNull;

public class GitUtil {
    public static final Pattern URL_PATTERN = Pattern.compile("^(https?|ftp)://[^\\s/$.?#].\\S*$");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String getCurrentBranch(File file) {
        if (!file.exists()) {
            return "";
        }
        try (Git git = Git.open((File)file);){
            Ref head = git.getRepository().findRef("HEAD");
            if (head.isSymbolic()) {
                String string2 = head.getTarget().getName().substring("refs/heads/".length());
                return string2;
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String getCurrentHeadSha1(File file, int length) {
        if (!file.exists()) {
            return "";
        }
        try (Git git = Git.open((File)file);){
            ObjectId head = git.getRepository().resolve("HEAD");
            if (head != null) {
                String string2 = head.name().substring(0, Math.min(length, head.name().length()));
                return string2;
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isGitRepo(File file) {
        boolean bl;
        block9: {
            if (!file.exists()) {
                return false;
            }
            Git ignored = Git.open((File)file);
            try {
                bl = true;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    public static boolean isGitRepoRemote(File file, String remoteUrl) {
        boolean bl;
        block9: {
            if (!file.exists()) {
                return false;
            }
            Git git = Git.open((File)file);
            try {
                String remote = git.getRepository().getConfig().getString("remote", "origin", "url");
                bl = remote.equals(remoteUrl);
                if (git == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            git.close();
        }
        return bl;
    }

    @NotNull
    public static List<String> getBranches(File file) {
        List<String> list;
        block9: {
            if (!file.exists()) {
                return List.of();
            }
            Git git = Git.open((File)file);
            try {
                list = git.branchList().call().stream().map(Ref::getName).toList();
                if (git == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | GitAPIException e) {
                    e.printStackTrace();
                    return List.of();
                }
            }
            git.close();
        }
        return list;
    }

    @NotNull
    public static List<String> getTrackedDatapacks(File parentFolder) {
        if (!parentFolder.exists()) {
            return List.of();
        }
        File[] files = parentFolder.listFiles();
        if (files == null) {
            return List.of();
        }
        return Stream.of(files).filter(File::isDirectory).filter(GitUtil::isGitRepo).map(File::getName).toList();
    }
}

