/*
 * Decompiled with CFR 0.152.
 */
package dev.neylz.gitpuller.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.neylz.gitpuller.util.GitUtil;
import dev.neylz.gitpuller.util.TokenManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5218;
import net.minecraft.class_7157;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitCheckoutCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"git").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"checkout").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"pack name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(GitUtil.getTrackedDatapacks(((class_2168)ctx.getSource()).method_9211().method_27050(class_5218.field_24186).toFile()), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"branch", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> class_2172.method_9265(GitUtil.getBranches(new File(((class_2168)ctx.getSource()).method_9211().method_27050(class_5218.field_24186).toFile(), StringArgumentType.getString((CommandContext)ctx, (String)"pack name"))), (SuggestionsBuilder)builder)).executes(ctx -> GitCheckoutCommand.checkout((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"pack name"), StringArgumentType.getString((CommandContext)ctx, (String)"branch")))))));
    }

    private static int checkout(CommandContext<class_2168> ctx, String pack, String branch) throws CommandSyntaxException {
        File packDir = new File(((class_2168)ctx.getSource()).method_9211().method_27050(class_5218.field_24186).toFile(), pack);
        if (!packDir.exists()) {
            throw new CommandSyntaxException(null, () -> "Datapack " + pack + " does not exist");
        }
        if (!GitUtil.isGitRepo(packDir)) {
            throw new CommandSyntaxException(null, () -> "Datapack " + pack + " is not a git repository");
        }
        GitCheckoutCommand.gitCheckout((class_2168)ctx.getSource(), packDir, branch);
        return 1;
    }

    private static void gitCheckout(class_2168 source, File file, String ref) throws CommandSyntaxException {
        block18: {
            try (Git git = Git.open((File)file);){
                ((FetchCommand)git.fetch().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(TokenManager.getInstance().getToken(), ""))).call();
                if (GitCheckoutCommand.isSHA1(ref)) {
                    Repository repository = git.getRepository();
                    try (RevWalk revWalk = new RevWalk(repository);){
                        RevCommit commit = revWalk.parseCommit((AnyObjectId)repository.resolve(ref));
                        git.checkout().setName(ref).setCreateBranch(true).setStartPoint(commit).call();
                        source.method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Checked out commit ").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)ref).method_27692(class_124.field_1076)), true);
                        break block18;
                    }
                    catch (IOException e) {
                        throw new CommandSyntaxException(null, () -> "Failed to checkout commit " + ref);
                    }
                }
                List branchList = git.branchList().call();
                boolean branchExists = branchList.stream().anyMatch(branch -> branch.getName().equals("refs/heads/" + ref));
                if (!branchExists) {
                    git.checkout().setCreateBranch(true).setName(ref).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + ref).call();
                } else {
                    git.checkout().setName(ref).call();
                }
                source.method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Checked out branch ").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)ref).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" in ").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)("[" + file.getName() + "]")).method_27692(class_124.field_1054)), true);
            }
            catch (IOException | GitAPIException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isSHA1(String ref) {
        return Pattern.matches("^[a-fA-F0-9]{40}$", ref);
    }
}

