/*
 * Decompiled with CFR 0.152.
 */
package dev.neylz.gitpuller.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.neylz.gitpuller.util.GitUtil;
import dev.neylz.gitpuller.util.ModConfig;
import dev.neylz.gitpuller.util.TokenManager;
import java.io.File;
import java.nio.file.Path;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5218;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitCloneCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        if (ModConfig.isMonoRepo()) {
            return;
        }
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"git").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clone").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(context -> GitCloneCommand.cloneDatapack((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"url")))))));
    }

    private static int cloneDatapack(CommandContext<class_2168> ctx, String name, String remoteUrl) throws CommandSyntaxException {
        if (!GitUtil.URL_PATTERN.matcher(remoteUrl).matches()) {
            throw new CommandSyntaxException(null, () -> "Invalid URL: " + remoteUrl);
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Cloning from ").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)remoteUrl).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" into the datapack ").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)("[" + name + "]")).method_27692(class_124.field_1054)), true);
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        try {
            GitCloneCommand.clone(server, remoteUrl, name);
        }
        catch (CommandSyntaxException e) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Failed to clone repository: ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061)), true);
            return 0;
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Successfully cloned repository").method_27692(class_124.field_1060)), true);
        return 1;
    }

    private static void clone(MinecraftServer server, String remoteUrl, String name) throws CommandSyntaxException {
        Path worldDir = server.method_27050(class_5218.field_24186);
        File datapackDir = new File(worldDir.toFile(), name);
        if (datapackDir.exists()) {
            throw new CommandSyntaxException(null, () -> "Datapack \"" + name + "\" already exists");
        }
        try {
            ((CloneCommand)Git.cloneRepository().setURI(remoteUrl).setDirectory(datapackDir).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(TokenManager.getInstance().getToken(), ""))).call();
        }
        catch (GitAPIException e) {
            e.printStackTrace();
            throw new CommandSyntaxException(null, () -> "Failed to clone repository: " + e.getMessage());
        }
    }
}

