/*
 * Decompiled with CFR 0.152.
 */
package dev.neylz.gitpuller.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.neylz.gitpuller.GitPuller;
import dev.neylz.gitpuller.util.GitUtil;
import dev.neylz.gitpuller.util.ModConfig;
import dev.neylz.gitpuller.util.TokenManager;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5218;
import net.minecraft.class_7157;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitPullCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder pullCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"pull").requires(source -> source.method_9259(2));
        pullCommand = !ModConfig.isMonoRepo() ? (LiteralArgumentBuilder)pullCommand.then(class_2170.method_9244((String)"pack name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(GitUtil.getTrackedDatapacks(((class_2168)ctx.getSource()).method_9211().method_27050(class_5218.field_24186).toFile()), (SuggestionsBuilder)builder)).executes(ctx -> GitPullCommand.pullPack((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"pack name")))) : (LiteralArgumentBuilder)pullCommand.executes(GitPullCommand::pullMonoPack);
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"git").then((ArgumentBuilder)pullCommand));
    }

    private static int pullMonoPack(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Pulling changes from remote repository").method_27692(class_124.field_1060)), true);
        File file = ((class_2168)ctx.getSource()).method_9211().method_27050(class_5218.field_24186).toFile();
        String sha1 = GitUtil.getCurrentHeadSha1(file, 7);
        if (!GitPullCommand.gitPull((class_2168)ctx.getSource(), file)) {
            throw new CommandSyntaxException(null, () -> "Failed to pull changes from distant repository");
        }
        String newSha1 = GitUtil.getCurrentHeadSha1(file, 7);
        if (!sha1.equals(newSha1)) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Pulled changes").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)sha1).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" -> ").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)newSha1).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1070)), true);
        }
        return 1;
    }

    private static int pullPack(CommandContext<class_2168> ctx, String packName) throws CommandSyntaxException {
        File file = new File(((class_2168)ctx.getSource()).method_9211().method_27050(class_5218.field_24186).toFile(), packName);
        if (!file.exists()) {
            throw new CommandSyntaxException(null, () -> "Datapack " + packName + " does not exist");
        }
        if (!GitUtil.isGitRepo(file)) {
            throw new CommandSyntaxException(null, () -> "Datapack " + packName + " is not a git repository");
        }
        String sha1 = GitUtil.getCurrentHeadSha1(file, 7);
        if (!GitPullCommand.gitPull((class_2168)ctx.getSource(), file)) {
            throw new CommandSyntaxException(null, () -> "Failed to pull changes from " + packName);
        }
        String newSha1 = GitUtil.getCurrentHeadSha1(file, 7);
        if (!sha1.equals(newSha1)) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Pulled changes from ").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)("[" + packName + "]")).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)sha1).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" -> ").method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)newSha1).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1070)), true);
        }
        return 1;
    }

    private static boolean gitPull(class_2168 sender, File repoDir) throws CommandSyntaxException {
        try {
            Git git = Git.open((File)repoDir);
            ((FetchCommand)git.fetch().setRemoveDeletedRefs(true).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(TokenManager.getInstance().getToken(), ""))).call();
            ((PullCommand)git.pull().setRebase(true).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(TokenManager.getInstance().getToken(), ""))).call();
            GitPuller.LOGGER.info("Fetched changes from remote repository");
            sender.method_9226(() -> class_2561.method_43473().method_27693("Fetched changes from remote repository").method_27692(class_124.field_1060), true);
            return true;
        }
        catch (IOException | GitAPIException e) {
            e.printStackTrace();
            throw new CommandSyntaxException(null, () -> GitPullCommand.lambda$gitPull$11((Exception)e));
        }
    }

    private static /* synthetic */ String lambda$gitPull$11(Exception e) {
        return "Failed to pull changes from remote repository: " + e.getMessage();
    }
}

