/*
 * Decompiled with CFR 0.152.
 */
package net.ultrastudios.lorelink.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class Advancements {
    protected static final Gson GSON = new Gson();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean grantOfflineAdvancement(MinecraftServer server, UUID playerUUID, String advancementId, Advancement advancement) {
        JsonObject existing;
        JsonObject playerData;
        Path playerFile;
        block23: {
            Path advancementsDir = server.getWorldPath(LevelResource.PLAYER_ADVANCEMENTS_DIR);
            if (Files.notExists(advancementsDir, new LinkOption[0])) {
                try {
                    Files.createDirectory(advancementsDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    System.err.println("Could not create advancements directory");
                    return false;
                }
            }
            if (Files.exists(playerFile = advancementsDir.resolve(playerUUID.toString() + ".json"), new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(playerFile);){
                    JsonElement json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                    if (!json.isJsonObject()) {
                        System.err.println("Wrong format in advancements file for player " + String.valueOf(playerUUID));
                        boolean bl = false;
                        return bl;
                    }
                    playerData = json.getAsJsonObject();
                    break block23;
                }
                catch (IOException e) {
                    System.err.println("Failed to read advancements file for player " + String.valueOf(playerUUID));
                    return false;
                }
            }
            playerData = new JsonObject();
        }
        if (playerData.has(advancementId) && (existing = playerData.getAsJsonObject(advancementId)).has("done") && existing.get("done").getAsBoolean()) {
            return false;
        }
        JsonObject advEntry = new JsonObject();
        Set criteriaSet = advancement.criteria().keySet();
        DateTimeFormatter f = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT).withZone(ZoneId.systemDefault());
        JsonObject criteria = new JsonObject();
        for (String c : criteriaSet) {
            criteria.addProperty(c, f.format(Instant.now()));
        }
        advEntry.add("criteria", (JsonElement)criteria);
        advEntry.addProperty("done", Boolean.valueOf(true));
        playerData.add(advancementId, (JsonElement)advEntry);
        try (BufferedWriter writer = Files.newBufferedWriter(playerFile, new OpenOption[0]);){
            GSON.toJson((JsonElement)playerData, (Appendable)writer);
            return true;
        }
        catch (IOException e) {
            System.err.println("Failed to write advancements file for player " + String.valueOf(playerUUID));
            return false;
        }
    }
}

