/*
 * Decompiled with CFR 0.152.
 */
package net.ultrastudios.lorelink.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;

public class BanListHelper {
    private static final Gson GSON = new Gson();

    public static UUID getBannedPlayerUuidByName(File list, String name) throws IOException {
        Path file = list.toPath();
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            JsonArray arr = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            for (JsonElement el : arr) {
                JsonObject obj = el.getAsJsonObject();
                String bannedName = obj.get("name").getAsString();
                if (!name.equalsIgnoreCase(bannedName)) continue;
                UUID uUID = UUID.fromString(obj.get("uuid").getAsString());
                return uUID;
            }
        }
        return null;
    }
}

