/*
 * Decompiled with CFR 0.152.
 */
package net.ultrastudios.lorelink.utils.config;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import net.ultrastudios.lorelink.utils.config.IFallbackEnum;
import org.jetbrains.annotations.NotNull;

class EnumDeserializerFactory
implements TypeAdapterFactory {
    EnumDeserializerFactory() {
    }

    public <T> TypeAdapter<T> create(Gson gson, @NotNull TypeToken<T> typeToken) {
        Class rawType = typeToken.getRawType();
        if (!Enum.class.isAssignableFrom(rawType)) {
            return null;
        }
        final Class<Enum> enumClass = rawType.asSubclass(Enum.class);
        return new TypeAdapter<T>(this){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                } else {
                    out.value(((Enum)value).name());
                }
            }

            public T read(JsonReader in) throws IOException {
                Enum[] constants;
                JsonToken peek = in.peek();
                if (peek == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                String str = in.nextString();
                if (str == null) {
                    return null;
                }
                for (Enum c : (Enum[])enumClass.getEnumConstants()) {
                    if (!c.name().equals(str)) continue;
                    return c;
                }
                if (IFallbackEnum.class.isAssignableFrom(enumClass) && (constants = (Enum[])enumClass.getEnumConstants()) != null && constants.length > 0) {
                    IFallbackEnum holder = (IFallbackEnum)((Object)constants[0]);
                    Object fb = holder.getFallback();
                    return fb;
                }
                return null;
            }
        };
    }
}

