/*
 * Decompiled with CFR 0.152.
 */
package net.ultrastudios.lorelink.utils.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.ultrastudios.lorelink.Constants;
import net.ultrastudios.lorelink.utils.config.EnumDeserializerFactory;

public class UltraConfig<T> {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapterFactory((TypeAdapterFactory)new EnumDeserializerFactory()).create();
    private final Path configPath;
    private final Class<T> tClass;
    private T buffer;
    private final T defaultConfig;

    public UltraConfig(Class<T> tClass, Path path, T defaultValue) {
        this.configPath = path;
        this.tClass = tClass;
        this.defaultConfig = defaultValue;
        this.buffer = defaultValue;
    }

    public T get() {
        return this.buffer;
    }

    public void load() {
        try {
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                this.buffer = this.defaultConfig;
                this.save(this.defaultConfig);
                return;
            }
            this.buffer = this.gson.fromJson(new String(Files.readAllBytes(this.configPath)), this.tClass);
        }
        catch (IOException e) {
            Constants.LOG.error(e.getMessage());
            this.buffer = this.defaultConfig;
        }
        catch (JsonSyntaxException e) {
            this.buffer = this.defaultConfig;
            this.save(this.defaultConfig);
        }
    }

    public void save(T data) {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            Files.write(this.configPath, this.gson.toJson(data).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Constants.LOG.error("Error during config file saving: {}", (Object)e.getMessage());
        }
        finally {
            this.buffer = data;
        }
    }

    public void update() {
        this.save(this.buffer);
    }

    public Class<T> getType() {
        return this.tClass;
    }
}

