/*
 * Decompiled with CFR 0.152.
 */
package net.ultrastudios.lorelink.utils.config;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import net.ultrastudios.lorelink.utils.config.UltraConfig;
import org.jetbrains.annotations.NotNull;

public class UltraConfigManager {
    private static final HashMap<String, UltraConfig<?>> configs = new HashMap();

    public static <T> void register(String modID, @NotNull Path configDir, Class<T> tClass, T defaultConfig) {
        configs.put(modID, new UltraConfig<T>(tClass, configDir.resolve("ultraconfig").resolve(modID + ".json"), defaultConfig));
        configs.get(modID).load();
    }

    @NotNull
    public static <T> UltraConfig<T> get(String modID, Class<T> tClass) throws IllegalArgumentException {
        UltraConfig<?> config = configs.get(modID);
        if (config != null && config.getType().equals(tClass)) {
            return config;
        }
        throw new IllegalArgumentException("Config not found for modID: " + modID + " with type: " + tClass.getName());
    }

    public static boolean contains(String modID) {
        return configs.containsKey(modID);
    }

    public static void reload(String modID) {
        configs.get(modID).load();
    }

    public static UltraConfig<?> getRaw(String modID) {
        return configs.get(modID);
    }

    public static <T> Optional<UltraConfig<T>> getOptional(String modID, Class<T> tClass) {
        UltraConfig<?> config = configs.get(modID);
        if (config != null && config.getType().equals(tClass)) {
            return Optional.of(config);
        }
        return Optional.empty();
    }
}

