/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.ashmeetop.feather_remake.HudEditorScreen;
import org.ashmeetop.feather_remake.client.config.CapeConfig;
import org.ashmeetop.feather_remake.client.config.HitColorConfig;
import org.ashmeetop.feather_remake.client.config.TimeChangerConfig;
import org.ashmeetop.feather_remake.client.config.TintConfig;
import org.ashmeetop.feather_remake.client.freelook.PerspectiveHandler;
import org.ashmeetop.feather_remake.client.freelook.PerspectiveKeybinds;
import org.ashmeetop.feather_remake.client.freelook.Perspectivecamera;
import org.ashmeetop.feather_remake.client.gui.element.FullGrassModCard;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;
import org.ashmeetop.feather_remake.client.hudmanage.HudPresetManager;
import org.ashmeetop.feather_remake.client.input.ZoomScrollHandler;
import org.ashmeetop.feather_remake.client.motionblur.ShaderUtils;
import org.ashmeetop.feather_remake.client.settings.CrosshairSettings;
import org.ashmeetop.feather_remake.client.settings.FeatherHudManager;
import org.ashmeetop.feather_remake.client.settings.FeatherSettings;
import org.ashmeetop.feather_remake.client.settings.FogSettings;
import org.ashmeetop.feather_remake.client.settings.FullbrightSettings;
import org.ashmeetop.feather_remake.client.settings.ZoomSettings;
import org.ashmeetop.feather_remake.client.util.ZoomMod;
import org.ashmeetop.feather_remake.client.waypoint.WaypointManager;
import org.ashmeetop.feather_remake.client.waypoint.WaypointRenderer;
import org.ashmeetop.feather_remake.client.waypoint.WaypointScreen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Feather_remake
implements ClientModInitializer {
    public static final String MOD_ID = "feather_remake";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"feather_remake");
    private static class_304 zoomKey;
    private static class_304 openHudEditor;
    private static class_304 newWaypointKey;
    private static boolean shaderEnabled;
    private static boolean originalSmooth;
    private static boolean scrollRegistered;

    public void onInitializeClient() {
        LOGGER.info("Initializing Feather Remake mod");
        try {
            zoomKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Zoom", 67, "feather general"));
            openHudEditor = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Open HUD Editor", 74, "feather general"));
            newWaypointKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("New Waypoint Screen", 75, "feather general"));
            FeatherHudManager.init();
            FeatherSettings.load();
            CapeConfig.load();
            HitColorConfig.load();
            ShaderUtils.init();
            WaypointManager.loadWaypoints();
            FullbrightSettings.load();
            CrosshairSettings.load();
            ZoomSettings.load();
            TintConfig.load();
            FeatherSettings.load();
            TimeChangerConfig.load();
            FogSettings.load();
            for (HudElement hud : FeatherHudManager.getHuds()) {
                HudPresetManager.load(hud);
            }
            ClientTickEvents.END_CLIENT_TICK.register(client -> FullGrassModCard.tick());
            ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
                if (!scrollRegistered) {
                    ZoomScrollHandler.init();
                    scrollRegistered = true;
                    LOGGER.info("Scroll handler registered (CLIENT_STARTED).");
                }
            });
            ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
                FeatherSettings.save();
                TimeChangerConfig.save();
                System.out.println("[FeatherRemake] HUD settings saved.");
            });
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                PerspectiveHandler.onClientTick();
                Perspectivecamera.onClientTick();
                if (newWaypointKey.method_1436()) {
                    client.method_1507((class_437)new WaypointScreen());
                }
                if (openHudEditor.method_1436()) {
                    client.method_1507((class_437)new HudEditorScreen());
                }
                boolean zooming = zoomKey.method_1434();
                ZoomMod.setZooming(zooming);
                if (client.field_1690 != null) {
                    if (zooming) {
                        originalSmooth = client.field_1690.field_1914;
                        client.field_1690.field_1914 = true;
                    } else {
                        client.field_1690.field_1914 = false;
                    }
                }
                if (!shaderEnabled) {
                    ShaderUtils.loadIrisShaderPack();
                    shaderEnabled = true;
                }
                if (client.field_1755 == null) {
                    TintConfig.save();
                    FullbrightSettings.save();
                    FeatherSettings.save();
                    FogSettings.save();
                }
                FeatherHudManager.tickAll();
                FullbrightSettings.tick();
            });
            HudRenderCallback.EVENT.register((graphics, tickDelta) -> {
                class_310 mc = class_310.method_1551();
                double mouseX = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4489();
                double mouseY = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4506();
                for (HudElement hud : FeatherHudManager.getHuds()) {
                    if (!hud.isEnabled()) continue;
                    hud.render(graphics, false, mouseX, mouseY);
                }
            });
            FeatherHudManager.init();
            WaypointRenderer.register();
            PerspectiveKeybinds.register();
            LOGGER.info("Feather Remake initialization complete.");
        }
        catch (Exception e) {
            LOGGER.error("Mod initialization failed!", (Throwable)e);
        }
    }

    static {
        shaderEnabled = false;
        originalSmooth = false;
        scrollRegistered = false;
    }
}

