/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake;

import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.ashmeetop.feather_remake.client.cosmetics.CapeSelectionScreen;
import org.ashmeetop.feather_remake.client.gui.FeatherRemakeScreen;
import org.ashmeetop.feather_remake.client.gui.LogoSelectorScreen;
import org.ashmeetop.feather_remake.client.gui.ServerSelectScreen;
import org.ashmeetop.feather_remake.client.gui.TintSettingsScreen;
import org.ashmeetop.feather_remake.client.gui.element.TexturedButton;
import org.ashmeetop.feather_remake.client.gui.element.ToggleSwitch;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;
import org.ashmeetop.feather_remake.client.settings.FeatherHudManager;
import org.ashmeetop.feather_remake.client.settings.FeatherSettings;

public class HudEditorScreen
extends class_437 {
    private static final class_2960 SQUARE_LOGO = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/logo.png");
    private static final class_2960 BUTTON_ICON_1 = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/cosmetics.png");
    private static final class_2960 BUTTON_ICON_2 = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/fc.png");
    private static final class_2960 BUTTON_ICON_3 = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/server.png");
    private static final class_2960 BUTTON_ICON_4 = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/display.png");
    private static final int GRID_SIZE = 20;
    private boolean showGrid = true;
    private int guideX = -1;
    private int guideY = -1;
    private boolean snapToGridEnabled = true;
    private double dragOffsetX;
    private double dragOffsetY;
    private boolean dragging = false;
    private boolean resizing = false;
    private HudElement selectedHud = null;
    private float aspectRatio = 1.0f;
    private int modButtonX;
    private int modButtonY;
    private int modButtonWidth;
    private int modButtonHeight;

    public HudEditorScreen() {
        super((class_2561)class_2561.method_43470((String)"HUD Editor"));
    }

    protected void method_25426() {
        super.method_25426();
        if (this.field_22787 != null) {
            this.field_22787.field_1773.method_62905();
        }
        this.modButtonWidth = 100;
        this.modButtonHeight = 20;
        this.modButtonX = (this.field_22789 - this.modButtonWidth) / 2;
        this.modButtonY = (this.field_22790 - this.modButtonHeight) / 2;
        this.method_37063((class_364)new TexturedButton(this.modButtonX, this.modButtonY, this.modButtonWidth, this.modButtonHeight, 0, 0, (class_2561)class_2561.method_43470((String)""), btn -> {
            FeatherSettings.save();
            class_310.method_1551().method_1507((class_437)new FeatherRemakeScreen());
        }, class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/settings.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/settings1.png")));
        int squareSize = 20;
        int spacing = 5;
        int totalWidth = squareSize * 4 + spacing * 3;
        int startX = (this.field_22789 - totalWidth) / 2;
        int startY = this.modButtonY + this.modButtonHeight + 2;
        this.method_37063((class_364)new TexturedButton(startX, startY, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new CapeSelectionScreen()), BUTTON_ICON_1, BUTTON_ICON_1));
        this.method_37063((class_364)new TexturedButton(startX + (squareSize + spacing), startY, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new LogoSelectorScreen()), BUTTON_ICON_2, BUTTON_ICON_2));
        this.method_37063((class_364)new TexturedButton(startX + 2 * (squareSize + spacing), startY, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new ServerSelectScreen()), BUTTON_ICON_3, BUTTON_ICON_3));
        this.method_37063((class_364)new TexturedButton(startX + 3 * (squareSize + spacing), startY, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new TintSettingsScreen(this)), BUTTON_ICON_4, BUTTON_ICON_4));
        int switchWidth = 80;
        int switchHeight = 20;
        int margin = 8;
        ToggleSwitch toggle = new ToggleSwitch(this.field_22789 - switchWidth - margin, margin, switchWidth, switchHeight, "GRID", this.snapToGridEnabled, enabled -> {
            this.snapToGridEnabled = enabled;
        });
        this.method_37063((class_364)toggle);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics);
        if (this.showGrid && (this.dragging || this.resizing) && this.guideX >= 0 && this.guideY >= 0) {
            graphics.method_25294(this.guideX, 0, this.guideX + 1, this.field_22790, -2130706433);
            graphics.method_25294(0, this.guideY, this.field_22789, this.guideY + 1, -2130706433);
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
        FeatherHudManager.renderAll(graphics, true);
        int logoSize = 32;
        int logoX = this.modButtonX + (this.modButtonWidth - logoSize) / 2;
        int logoY = this.modButtonY - logoSize - 5;
        graphics.method_25290(class_1921::method_62275, SQUARE_LOGO, logoX, logoY, 0.0f, 0.0f, logoSize, logoSize, logoSize, logoSize);
    }

    private void renderBackground(class_332 graphics) {
    }

    private int snapToGrid(int value) {
        if (!this.snapToGridEnabled) {
            return value;
        }
        return Math.round((float)value / 20.0f) * 20;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 71) {
            this.showGrid = !this.showGrid;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (HudElement hud : FeatherHudManager.getHuds()) {
            if (!hud.isHovered(mouseX, mouseY)) continue;
            this.selectedHud = hud;
            this.resizing = hud.isResizing(mouseX, mouseY);
            this.aspectRatio = (float)hud.getWidth() / (float)hud.getHeight();
            if (!this.resizing) {
                this.dragging = true;
                this.dragOffsetX = mouseX - (double)hud.getX();
                this.dragOffsetY = mouseY - (double)hud.getY();
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.selectedHud != null) {
            if (this.resizing) {
                int newWidth = (int)(mouseX - (double)this.selectedHud.getX());
                int newHeight = (int)(mouseY - (double)this.selectedHud.getY());
                if ((float)(newWidth = this.snapToGrid(newWidth)) / (float)(newHeight = this.snapToGrid(newHeight)) > this.aspectRatio) {
                    newWidth = (int)((float)newHeight * this.aspectRatio);
                } else {
                    newHeight = (int)((float)newWidth / this.aspectRatio);
                }
                this.selectedHud.setSize(newWidth, newHeight);
                this.guideX = this.selectedHud.getX() + newWidth;
                this.guideY = this.selectedHud.getY() + newHeight;
            } else if (this.dragging) {
                int newX = (int)(mouseX - this.dragOffsetX);
                int newY = (int)(mouseY - this.dragOffsetY);
                newX = this.snapToGrid(newX);
                newY = this.snapToGrid(newY);
                this.selectedHud.setPosition(newX, newY);
                this.guideX = newX;
                this.guideY = newY;
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.selectedHud != null && (this.dragging || this.resizing)) {
            FeatherSettings.save();
        }
        this.dragging = false;
        this.resizing = false;
        this.selectedHud = null;
        this.guideX = -1;
        this.guideY = -1;
        return super.method_25406(mouseX, mouseY, button);
    }
}

