/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class LinkConfig {
    private static final String FILE_NAME = "config/feather_remake/feather-remake-links.properties";
    private static final Properties PROPS = new Properties();
    public static String DISCORD = "https://discord.gg/RBDEjJX8ZM";
    public static String YOUTUBE = "https://youtube.com/@ashmeet_op?si=e1w4k7SWBdnVmwOs";
    public static String MODRINTH = "https://modrinth.com/mod/feather-remake";
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("config/feather_remake/feather-remake-links.properties");

    public static void load() {
        block9: {
            try {
                File f = configPath.toFile();
                if (f.exists()) {
                    try (FileInputStream in = new FileInputStream(f);){
                        PROPS.load(in);
                    }
                    DISCORD = PROPS.getProperty("discord", DISCORD);
                    YOUTUBE = PROPS.getProperty("youtube", YOUTUBE);
                    MODRINTH = PROPS.getProperty("modrinth", MODRINTH);
                    break block9;
                }
                LinkConfig.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        try {
            PROPS.setProperty("discord", DISCORD);
            PROPS.setProperty("youtube", YOUTUBE);
            PROPS.setProperty("modrinth", MODRINTH);
            File parent = configPath.getParent().toFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try (FileOutputStream out = new FileOutputStream(configPath.toFile());){
                PROPS.store(out, "Feather Remake: editable external links");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        LinkConfig.load();
    }
}

