/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import org.ashmeetop.feather_remake.client.config.TimeChanger;

public class TimeChangerConfig {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final File file = new File("config/feather_remake/timechanger.json");

    public static void save() {
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((Object)new Data(TimeChanger.isEnabled(), TimeChanger.getCustomTime()), (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        try {
            if (!file.exists()) {
                return;
            }
            Data data = (Data)gson.fromJson((Reader)new FileReader(file), Data.class);
            TimeChanger.setEnabled(data.enabled);
            TimeChanger.setCustomTime(data.customTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Data {
        boolean enabled;
        long customTime;

        Data(boolean enabled, long customTime) {
            this.enabled = enabled;
            this.customTime = customTime;
        }
    }
}

