/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.cosmetics;

import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_746;
import org.ashmeetop.feather_remake.client.config.CapeConfig;
import org.ashmeetop.feather_remake.client.config.TintConfig;
import org.ashmeetop.feather_remake.client.cosmetics.CapeManager;
import org.ashmeetop.feather_remake.client.gui.element.HueShiftedImage;
import org.ashmeetop.feather_remake.client.gui.element.TexturedButton;

public class CapeSelectionScreen
extends class_437 {
    private float playerRotation = 0.0f;
    private long lastFrameTime = System.currentTimeMillis();
    private int selectedCapeIndex;
    private int contentHeight;
    private static final int COLOR_PRIMARY = -13318311;
    private static final int COLOR_SECONDARY = -7434605;
    private static final int COLOR_TOGGLE_ON = -50384;
    private static final int COLOR_TOGGLE_OFF = -13318311;
    private static final int COLOR_BUTTON_TEXT = -1;
    private static final class_2960 LOGO = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/f.png");
    private static final class_2960[] CAPE_PREVIEWS = new class_2960[]{class_2960.method_60655((String)"feather_remake", (String)"textures/cape/ui/c1.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/cape/ui/c2.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/cape/ui/c3.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/cape/ui/c4.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/cape/ui/c5.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/cape/ui/c6.png")};
    private int contentWidth;
    private int contentTop;
    private int contentBottom;
    private int contentLeft;
    private int contentRight;

    public CapeSelectionScreen() {
        super((class_2561)class_2561.method_43470((String)""));
        this.selectedCapeIndex = CapeConfig.get().selectedCapeIndex;
        this.contentHeight = 230;
        this.contentWidth = 400;
    }

    public static boolean isCapeEnabled() {
        return CapeConfig.get().capeEnabled;
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.contentLeft = (this.field_22789 - this.contentWidth) / 2;
        this.contentRight = this.contentLeft + this.contentWidth;
        this.contentTop = (this.field_22790 - this.contentHeight) / 2;
        this.contentBottom = this.contentTop + this.contentHeight;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        UUID uuid = player.method_5667();
        this.method_37063((class_364)new IOSButton(this, centerX + 85, centerY + 80, 40, 20, (class_2561)class_2561.method_43473(), btn -> {
            CapeConfig.get().capeEnabled = !CapeConfig.get().capeEnabled;
            CapeConfig.save();
        }, () -> CapeConfig.get().capeEnabled));
        int gridStartX = this.contentLeft + 20;
        int gridStartY = this.contentTop + 20;
        int buttonSize = 40;
        int buttonSpacing = 12;
        for (int i = 0; i < CAPE_PREVIEWS.length; ++i) {
            final int index = i;
            int row = i / 3;
            int col = i % 3;
            int x = gridStartX + col * (buttonSize + buttonSpacing);
            int y = gridStartY + row * (buttonSize + buttonSpacing);
            this.method_37063((class_364)new TexturedButton(this, x, y, buttonSize, buttonSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> {
                this.selectedCapeIndex = index;
                CapeConfig.get().selectedCapeIndex = index;
                CapeConfig.save();
                CapeManager.setCape(uuid, index);
            }, CAPE_PREVIEWS[i], CAPE_PREVIEWS[i]){

                @Override
                public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
                    super.method_48579(graphics, mouseX, mouseY, delta);
                    if (CapeConfig.get().selectedCapeIndex == index) {
                        graphics.method_49601(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, -13318311);
                    }
                }
            });
        }
    }

    public void renderEntity(class_332 graphics, int x, int y, int size) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        double mouseX = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
        double mouseY = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
        class_490.method_2486((class_332)graphics, (int)(x - size / 2), (int)(y - size), (int)(x + size / 2), (int)(y + size), (int)size, (float)0.0625f, (float)((float)mouseX), (float)((float)mouseY), (class_1309)player);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_57734();
        graphics.method_25294(this.contentLeft, this.contentTop, this.contentRight, this.contentBottom, -15066598);
        graphics.method_25294(this.contentLeft - 6, this.contentTop - 6, this.contentRight + 6, this.contentBottom + 6, -16316665);
        int logoWidth = 70;
        int logoHeight = 23;
        int logoX = this.contentLeft - 5;
        int logoY = this.contentTop - logoHeight - 10;
        HueShiftedImage hueLogo = new HueShiftedImage(LOGO, TintConfig.get().hue);
        hueLogo.setHue(TintConfig.get().hue);
        graphics.method_25290(class_1921::method_62277, hueLogo.getShiftedTexture(), logoX, logoY, 0.0f, 0.0f, logoWidth, logoHeight, logoWidth, logoHeight);
        String capeName = "Cape " + (CapeConfig.get().selectedCapeIndex + 1);
        graphics.method_25300(this.field_22793, capeName, this.field_22789 / 2, this.contentTop + this.contentHeight + 10, -1);
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - this.lastFrameTime) / 1000.0f;
        this.lastFrameTime = currentTime;
        this.playerRotation += deltaTime * 100.0f;
        this.renderEntity(graphics, this.contentLeft + this.contentWidth - 80, this.contentTop + this.contentHeight - 120, 80);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
    }

    private class IOSButton
    extends class_4185 {
        private final BooleanSupplier toggleState;

        public IOSButton(CapeSelectionScreen capeSelectionScreen, int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress, BooleanSupplier toggleState) {
            super(x, y, width, height, message, onPress, field_40754);
            this.toggleState = toggleState;
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            boolean toggled = this.toggleState.getAsBoolean();
            int color = toggled ? -50384 : -13318311;
            graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, color);
            int thumbSize = this.field_22759 - 4;
            int thumbX = toggled ? this.method_46426() + this.field_22758 - thumbSize - 2 : this.method_46426() + 2;
            graphics.method_25294(thumbX, this.method_46427() + 2, thumbX + thumbSize, this.method_46427() + this.field_22759 - 2, -1);
        }
    }
}

