/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_404;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.ashmeetop.feather_remake.client.config.TintConfig;
import org.ashmeetop.feather_remake.client.cosmetics.CapeSelectionScreen;
import org.ashmeetop.feather_remake.client.freelook.PerspectiveModCard;
import org.ashmeetop.feather_remake.client.gui.ConnectingScreen;
import org.ashmeetop.feather_remake.client.gui.LoginScreen;
import org.ashmeetop.feather_remake.client.gui.TintSettingsScreen;
import org.ashmeetop.feather_remake.client.gui.WebpLibraryInstallerScreen;
import org.ashmeetop.feather_remake.client.gui.element.BlockOutlineModCard;
import org.ashmeetop.feather_remake.client.gui.element.CrosshairModCard;
import org.ashmeetop.feather_remake.client.gui.element.DynamicHueButton;
import org.ashmeetop.feather_remake.client.gui.element.FogModCard;
import org.ashmeetop.feather_remake.client.gui.element.HitColorModCard;
import org.ashmeetop.feather_remake.client.gui.element.HueShiftedImage;
import org.ashmeetop.feather_remake.client.gui.element.ModCard;
import org.ashmeetop.feather_remake.client.gui.element.MotionBlurModCard;
import org.ashmeetop.feather_remake.client.gui.element.TexturedButton;
import org.ashmeetop.feather_remake.client.gui.element.TimeChangerModCard;
import org.ashmeetop.feather_remake.client.gui.element.WaypointModCard;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;
import org.ashmeetop.feather_remake.client.input.ZoomModCard;
import org.ashmeetop.feather_remake.client.settings.FeatherHudManager;
import org.ashmeetop.feather_remake.client.settings.FeatherSettings;
import org.ashmeetop.feather_remake.client.util.FullbrightModCard;

public class FeatherRemakeScreen
extends class_437 {
    private static final int CARD_WIDTH = 117;
    private static final int CARD_HEIGHT = 71;
    private static final int PADDING = 3;
    private static final int COLUMNS = 4;
    private static final int CATEGORY_OFFSET = 25;
    private static final class_2960 CONTENT_BG = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/content_bg.png");
    private static final class_2960 LOGO = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/og.png");
    private static final class_2960 SEARCH_BAR_TEXTURE = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/search_bar.png");
    private static final class_2960[][] SIDE_BUTTON_TEXTURES = new class_2960[][]{{class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/chat.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/chat.png")}, {class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/cape.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/cape.png")}, {class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/tv.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/tv.png")}, {class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/gear.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/gear.png")}, {class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/chat1.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/chat1.png")}, {class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/refresh.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/side_buttons/refresh.png")}};
    private static final class_2960[][] CATEGORY_TEXTURES = new class_2960[][]{{class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/a.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/a1.png")}, {class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/p.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/p1.png")}, {class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/h.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/h1.png")}, {class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/n.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/n1.png")}};
    private class_342 searchBox;
    private String currentCategory = "All";
    private final class_4185[] sideButtons = new class_4185[6];
    private String lastSearchQuery = "";
    private final List<ModCard> allModCards = new ArrayList<ModCard>();
    private final CopyOnWriteArrayList<ModCard> visibleModCards = new CopyOnWriteArrayList();
    private boolean searchActive = false;
    private int contentTop;
    private int contentBottom;
    private int contentLeft;
    private int contentRight;
    private double scroll = 0.0;
    private double targetScroll = 0.0;
    private int maxScroll = 0;
    private boolean draggingScrollbar = false;
    private int lastMouseX;
    private int lastMouseY;
    private int totalWidth;
    private int contentHeight = 240;
    private boolean needsCardUpdate = true;
    private int firstVisibleRow = 0;
    private int lastVisibleRow = 0;

    public FeatherRemakeScreen() {
        super((class_2561)class_2561.method_43470((String)""));
        this.initializeModCards();
        this.totalWidth = 477;
    }

    private void initializeModCards() {
        this.allModCards.add(new HitColorModCard(0, 0));
        this.allModCards.add(new CrosshairModCard(0, 0));
        this.allModCards.add(new FullbrightModCard(0, 0));
        this.allModCards.add(new ZoomModCard(0, 0));
        this.allModCards.add(new FogModCard(0, 0));
        this.allModCards.add(new BlockOutlineModCard(0, 0));
        this.allModCards.add(new WaypointModCard(0, 0));
        this.allModCards.add(new TimeChangerModCard(0, 0));
        this.allModCards.add(new PerspectiveModCard(0, 0));
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            this.allModCards.add(new MotionBlurModCard(0, 0));
        }
        List<HudElement> huds = FeatherHudManager.getHuds();
        for (HudElement hud : huds) {
            this.allModCards.add(new ModCard(0, 0, hud.getIcon(), hud.getName(), hud::isEnabled, enabled -> {
                hud.setEnabled((boolean)enabled);
                FeatherSettings.save();
            }, hud, "hud"));
        }
        this.visibleModCards.addAll(this.allModCards);
    }

    protected void method_25426() {
        super.method_25426();
        this.calculateContentBounds();
        this.createCloseButton();
        this.createSideButtons();
        this.createSearchBox();
        this.createCategoryButtons();
        this.updateCardPositions();
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
    }

    private void calculateContentBounds() {
        this.contentTop = (this.field_22790 - this.contentHeight) / 2;
        this.contentBottom = this.contentTop + this.contentHeight + 2;
        this.contentLeft = (this.field_22789 - this.totalWidth) / 2;
        this.contentRight = this.contentLeft + this.totalWidth;
    }

    private void createCloseButton() {
        int gapFromRight = 4;
        int squareSize = 20;
        int logoHeight = 28;
        int buttonX = this.contentRight - squareSize - gapFromRight;
        DynamicHueButton closeButton = new DynamicHueButton(buttonX + 9, this.contentTop - logoHeight - 1, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507(null), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/01.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/1.png"), TintConfig.get().hue, 0.15f);
        this.method_37063((class_364)closeButton);
        TintSettingsScreen.registerButton(closeButton);
    }

    private void createSideButtons() {
        int sideButtonHeight = 23;
        int sideButtonWidth = 35;
        int logoWidth = 58;
        int logoX = this.contentLeft - logoWidth + 49;
        int logoY = this.contentTop - 32 - 5;
        int logoRight = logoX + logoWidth;
        int sideButtonX = logoRight + 5;
        int sideButtonY = logoY - 6 + 13;
        class_437[] screens = new class_437[]{new class_404((class_437)this, class_310.method_1551().field_1690), new CapeSelectionScreen(), new TintSettingsScreen(this), new WebpLibraryInstallerScreen(this), new ConnectingScreen(), new LoginScreen(this)};
        for (int i = 0; i < this.sideButtons.length; ++i) {
            int index = i;
            int x = sideButtonX + i * (sideButtonWidth + 5);
            this.sideButtons[i] = new TexturedButton(x, sideButtonY, sideButtonWidth, sideButtonHeight, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507(screens[index]), SIDE_BUTTON_TEXTURES[i][0], SIDE_BUTTON_TEXTURES[i][1]);
            this.method_37063((class_364)this.sideButtons[i]);
        }
    }

    private void createSearchBox() {
        int btnY = this.contentTop + 12 - 10;
        int paddingRight = 5;
        int searchWidth = 120;
        int searchHeight = 15;
        int searchX = this.contentRight - searchWidth - paddingRight;
        int searchY = btnY;
        this.searchBox = new class_342(this.field_22793, searchX, searchY, searchWidth, searchHeight, (class_2561)class_2561.method_43470((String)"Search..."));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1852("");
        this.searchBox.method_1863(this::onSearchQueryChanged);
        this.searchBox.method_1856(true);
        this.method_37063((class_364)this.searchBox);
    }

    private void createCategoryButtons() {
        int btnY = this.contentTop + 12 - 10;
        int btnXStart = this.contentLeft + 5;
        int buttonWidth = 38;
        int buttonHeight = 15;
        int gap = 2;
        String[] categories = new String[]{"all", "pvp", "hud", "new"};
        for (int i = 0; i < categories.length; ++i) {
            String category = categories[i];
            int x = btnXStart + i * (buttonWidth + gap);
            DynamicHueButton button = new DynamicHueButton(x, btnY, buttonWidth, buttonHeight, 0, 0, (class_2561)class_2561.method_43470((String)category.toUpperCase()), b -> this.setCategory(category), CATEGORY_TEXTURES[i][0], CATEGORY_TEXTURES[i][1], TintConfig.get().hue, 0.15f);
            this.method_37063((class_364)button);
            TintSettingsScreen.registerButton(button);
        }
    }

    private void onSearchQueryChanged(String query) {
        String newQuery = query.toLowerCase().trim();
        if (!this.lastSearchQuery.equals(newQuery)) {
            this.lastSearchQuery = newQuery;
            this.filterModCards();
        }
    }

    private void filterModCards() {
        this.visibleModCards.clear();
        if (this.lastSearchQuery.isEmpty()) {
            this.visibleModCards.addAll(this.allModCards);
            this.searchActive = false;
        } else {
            for (ModCard card : this.allModCards) {
                if (!card.getName().toLowerCase().contains(this.lastSearchQuery)) continue;
                this.visibleModCards.add(card);
            }
            this.searchActive = true;
        }
        this.scroll = 0.0;
        this.targetScroll = 0.0;
        this.needsCardUpdate = true;
    }

    private void updateCardPositions() {
        if (!this.needsCardUpdate) {
            return;
        }
        int totalRows = (int)Math.ceil((double)this.visibleModCards.size() / 4.0);
        int visibleHeight = this.contentBottom - this.contentTop - 25;
        this.maxScroll = Math.max(0, totalRows * 74 - visibleHeight);
        this.scroll = Math.max(0.0, Math.min(this.scroll, (double)this.maxScroll));
        this.targetScroll = Math.max(0.0, Math.min(this.targetScroll, (double)this.maxScroll));
        this.needsCardUpdate = false;
    }

    private void updateVisibleCardPositions() {
        int rowHeight = 74;
        int totalRows = (int)Math.ceil((double)this.visibleModCards.size() / 4.0);
        int visibleHeight = this.contentBottom - this.contentTop - 25;
        this.firstVisibleRow = Math.max(0, (int)(this.scroll / (double)rowHeight));
        this.lastVisibleRow = Math.min(totalRows - 1, (int)((this.scroll + (double)visibleHeight) / (double)rowHeight));
        int yOffset = this.contentTop + 25 - (int)this.scroll;
        for (int i = this.firstVisibleRow * 4; i <= this.lastVisibleRow * 4 + 3 && i < this.visibleModCards.size(); ++i) {
            ModCard card = this.visibleModCards.get(i);
            int row = i / 4;
            int col = i % 4;
            int x = this.contentLeft + col * 120;
            int y = yOffset + row * 74;
            card.method_46421(x);
            card.method_46419(y);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        super.method_57734();
        graphics.method_25290(class_1921::method_62275, CONTENT_BG, this.contentLeft - 6, this.contentTop - 6, 0.0f, 0.0f, this.contentRight - this.contentLeft + 12, this.contentBottom - this.contentTop + 12, 256, 256);
        int shadowHeight = 50;
        for (int i = 0; i < shadowHeight; ++i) {
            int alpha = (int)(100.0 * (1.0 - (double)((float)i / (float)shadowHeight)));
            graphics.method_25294(0, i, this.field_22789, i + 4, alpha << 24);
        }
        this.renderScrollableContent(graphics, mouseX, mouseY, delta);
        this.renderUIOverlay(graphics);
        this.renderSearchBar(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        int logoWidth = 58;
        int logoHeight = 32;
        int logoX = this.contentLeft - logoWidth + 49;
        int logoY = this.contentTop - logoHeight - 5;
        HueShiftedImage hueLogo = new HueShiftedImage(LOGO, TintConfig.get().hue);
        graphics.method_25290(class_1921::method_62277, hueLogo.getShiftedTexture(), logoX, logoY, 0.0f, 0.0f, logoWidth, logoHeight, logoWidth, logoHeight);
    }

    private void renderScrollableContent(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.applyScissor(this.contentLeft, this.contentTop + 25, this.contentRight - this.contentLeft, this.contentBottom - this.contentTop - 25);
        this.updateVisibleCardPositions();
        for (int i = this.firstVisibleRow * 4; i <= this.lastVisibleRow * 4 + 3 && i < this.visibleModCards.size(); ++i) {
            ModCard card = this.visibleModCards.get(i);
            card.method_25394(graphics, mouseX, mouseY, delta);
        }
        this.disableScissor();
        this.renderScrollbar(graphics);
    }

    private void renderUIOverlay(class_332 graphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        graphics.method_25290(class_1921::method_62275, CONTENT_BG, this.contentLeft, this.contentTop, 0.0f, 0.0f, this.contentRight - this.contentLeft, 25, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.contentTop - 24, 0xFFFFFF);
    }

    private void renderSearchBar(class_332 graphics) {
        graphics.method_25290(class_1921::method_62277, SEARCH_BAR_TEXTURE, this.searchBox.method_46426() - 4, this.searchBox.method_46427() - 4, 0.0f, 0.0f, this.searchBox.method_25368(), this.searchBox.method_25364() + 5, this.searchBox.method_25368(), this.searchBox.method_25364() + 5);
        this.searchBox.method_25394(graphics, this.lastMouseX, this.lastMouseY, 0.0f);
    }

    private void renderScrollbar(class_332 graphics) {
        int scrollbarWidth = 6;
        int scrollbarX = this.contentRight + 7;
        int scrollbarY = this.contentTop;
        int scrollbarHeight = this.contentBottom - this.contentTop;
        graphics.method_25294(scrollbarX, scrollbarY, scrollbarX + scrollbarWidth, scrollbarY + scrollbarHeight, 0x40AAAAAA);
        if (this.maxScroll > 0) {
            boolean trackHovering;
            float visibleRatio = Math.min(1.0f, (float)scrollbarHeight / (float)(scrollbarHeight + this.maxScroll));
            int thumbHeight = Math.max(12, Math.min(scrollbarHeight - 4, (int)((float)scrollbarHeight * visibleRatio)));
            float scrollRatio = (float)this.scroll / (float)this.maxScroll;
            int thumbY = scrollbarY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
            boolean hovering = this.lastMouseX >= scrollbarX - 2 && this.lastMouseX <= scrollbarX + scrollbarWidth + 2 && this.lastMouseY >= thumbY && this.lastMouseY <= thumbY + thumbHeight;
            boolean bl = trackHovering = this.lastMouseX >= scrollbarX - 2 && this.lastMouseX <= scrollbarX + scrollbarWidth + 2 && this.lastMouseY >= scrollbarY && this.lastMouseY <= scrollbarY + scrollbarHeight;
            int thumbColor = hovering ? -2039584 : (trackHovering ? -4144960 : -6250336);
            int thumbRadius = 3;
            graphics.method_25294(scrollbarX, thumbY + thumbRadius, scrollbarX + scrollbarWidth, thumbY + thumbHeight - thumbRadius, thumbColor);
            graphics.method_25294(scrollbarX + thumbRadius, thumbY, scrollbarX + scrollbarWidth - thumbRadius, thumbY + thumbRadius, thumbColor);
            graphics.method_25294(scrollbarX, thumbY + thumbRadius, scrollbarX + thumbRadius, thumbY + thumbRadius * 2, thumbColor);
            graphics.method_25294(scrollbarX + scrollbarWidth - thumbRadius, thumbY + thumbRadius, scrollbarX + scrollbarWidth, thumbY + thumbRadius * 2, thumbColor);
            graphics.method_25294(scrollbarX + thumbRadius, thumbY + thumbHeight - thumbRadius, scrollbarX + scrollbarWidth - thumbRadius, thumbY + thumbHeight, thumbColor);
            graphics.method_25294(scrollbarX, thumbY + thumbHeight - thumbRadius * 2, scrollbarX + thumbRadius, thumbY + thumbHeight - thumbRadius, thumbColor);
            graphics.method_25294(scrollbarX + scrollbarWidth - thumbRadius, thumbY + thumbHeight - thumbRadius * 2, scrollbarX + scrollbarWidth, thumbY + thumbHeight - thumbRadius, thumbColor);
            int highlightColor = 0x30FFFFFF;
            graphics.method_25294(scrollbarX + 1, thumbY + thumbRadius, scrollbarX + 2, thumbY + thumbHeight - thumbRadius, highlightColor);
        }
    }

    public void method_25432() {
        super.method_25432();
        if (this.field_22787 != null) {
            this.field_22787.field_1773.method_62905();
        }
    }

    public void setCategory(String category) {
        if (!this.currentCategory.equals(category)) {
            this.currentCategory = category;
            this.refreshModCards();
        }
    }

    private void refreshModCards() {
        this.visibleModCards.clear();
        for (ModCard card : this.allModCards) {
            if (!this.currentCategory.equalsIgnoreCase("all") && !card.category.equalsIgnoreCase(this.currentCategory)) continue;
            this.visibleModCards.add(card);
        }
        this.scroll = 0.0;
        this.targetScroll = 0.0;
        this.needsCardUpdate = true;
    }

    public boolean method_25401(double mouseX, double mouseY, double dx, double dy) {
        this.targetScroll -= dy * 30.0;
        this.targetScroll = Math.max(0.0, Math.min(this.targetScroll, (double)this.maxScroll));
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clickedSearch = this.searchBox.method_25402(mouseX, mouseY, button);
        if (!clickedSearch && this.searchBox.method_25370()) {
            this.searchBox.method_25365(false);
        }
        if (clickedSearch) {
            this.searchBox.method_25365(true);
        }
        int scrollbarX = this.contentRight + 8;
        int scrollbarY = this.contentTop;
        int scrollbarHeight = this.contentBottom - this.contentTop;
        if (button == 0 && mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 4) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
            this.draggingScrollbar = true;
            return true;
        }
        for (int i = this.firstVisibleRow * 4; i <= this.lastVisibleRow * 4 + 3 && i < this.visibleModCards.size(); ++i) {
            ModCard card = this.visibleModCards.get(i);
            if (!card.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return clickedSearch || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.draggingScrollbar && this.maxScroll > 0) {
            int scrollbarHeight = this.contentBottom - this.contentTop;
            float ratio = (float)(mouseY - (double)this.contentTop) / (float)scrollbarHeight;
            this.targetScroll = ratio * (float)this.maxScroll;
            this.targetScroll = Math.max(0.0, Math.min(this.targetScroll, (double)this.maxScroll));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256 && this.searchBox.method_25370()) {
            this.searchBox.method_25365(false);
            return true;
        }
        if (keyCode == 264) {
            this.targetScroll = Math.min(this.targetScroll + 30.0, (double)this.maxScroll);
        }
        if (keyCode == 265) {
            this.targetScroll = Math.max(this.targetScroll - 30.0, 0.0);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25393() {
        double scrollDiff = this.targetScroll - this.scroll;
        if (Math.abs(scrollDiff) > 0.1) {
            this.scroll += scrollDiff * 0.35;
            this.scroll = Math.max(0.0, Math.min(this.scroll, (double)this.maxScroll));
            this.needsCardUpdate = true;
        }
        this.updateCardPositions();
        for (int i = this.firstVisibleRow * 4; i <= this.lastVisibleRow * 4 + 3 && i < this.visibleModCards.size(); ++i) {
            this.visibleModCards.get(i);
            ModCard.tick();
        }
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.searchBox.method_25400(codePoint, modifiers)) {
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    private void applyScissor(int x, int y, int width, int height) {
        double scale = this.field_22787.method_22683().method_4495();
        int sx = (int)((double)x * scale);
        int sy = (int)((double)this.field_22787.method_22683().method_4506() - (double)(y + height) * scale);
        int sw = (int)((double)width * scale);
        int sh = (int)((double)height * scale);
        RenderSystem.enableScissor((int)sx, (int)sy, (int)sw, (int)sh);
    }

    private void disableScissor() {
        RenderSystem.disableScissor();
    }
}

