/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.gui;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginScreen
extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginScreen.class);
    private static final class_2561 TITLE = class_2561.method_43470((String)"Local Account Switcher");
    private static final class_2561 LOGIN_BUTTON_TEXT = class_2561.method_43470((String)"Login");
    private static final class_2561 BACK_BUTTON_TEXT = class_2561.method_43470((String)"Back");
    private static final class_2561 FIELD_LABEL = class_2561.method_43470((String)"Username");
    private static final class_2561 ADD_BUTTON_TEXT = class_2561.method_43470((String)"Add Account");
    private static final class_2561 REMOVE_BUTTON_TEXT = class_2561.method_43470((String)"Remove Selected");
    private static final Pattern USERNAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]{3,16}$");
    private static final List<String> SAVED_ACCOUNTS = new ArrayList<String>();
    private final class_437 parent;
    private AccountList accountList;
    private class_342 usernameField;
    private class_4185 loginButton;
    private class_4185 removeButton;
    private class_2561 statusMessage = class_2561.method_43473();
    private int statusColor = 0xFFFFFF;
    private static final Gson GSON = new Gson();
    private static final File ACCOUNTS_FILE = new File(class_310.method_1551().field_1697, "config/feather_remake/local_accounts.json");

    public LoginScreen(class_437 parent) {
        super(TITLE);
        this.parent = parent;
        LoginScreen.loadAccounts();
        if (SAVED_ACCOUNTS.isEmpty()) {
            SAVED_ACCOUNTS.add(class_310.method_1551().method_1548().method_1676());
            LoginScreen.saveAccounts();
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
    }

    protected void method_25426() {
        this.method_37067();
        int centerX = this.field_22789 / 2;
        int fieldWidth = 200;
        int buttonHeight = 20;
        int listWidth = 220;
        int listHeight = this.field_22790 / 2;
        int listX = centerX - listWidth / 2;
        int listY = 32;
        int buttonY = listY + listHeight + 4;
        int controlY = buttonY + buttonHeight + 10;
        this.usernameField = new class_342(this.field_22793, centerX - fieldWidth / 2, controlY, fieldWidth, buttonHeight, FIELD_LABEL);
        this.usernameField.method_1880(16);
        this.usernameField.method_1852(class_310.method_1551().method_1548().method_1676());
        this.usernameField.method_1863(s -> this.updateStatusMessage());
        this.method_37063((class_364)this.usernameField);
        this.method_48265((class_364)this.usernameField);
        this.loginButton = class_4185.method_46430((class_2561)LOGIN_BUTTON_TEXT, b -> this.attemptLogin(this.usernameField.method_1882().trim())).method_46434(centerX - fieldWidth / 2, controlY + buttonHeight + 4, fieldWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.loginButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)BACK_BUTTON_TEXT, b -> class_310.method_1551().method_1507(this.parent)).method_46434(centerX - fieldWidth / 2, controlY + buttonHeight * 2 + 8, fieldWidth, buttonHeight).method_46431());
        this.accountList = new AccountList(this.field_22787, listWidth, listHeight, listY, 24);
        this.accountList.method_46421(listX);
        this.method_37063((class_364)this.accountList);
        this.method_37063((class_364)class_4185.method_46430((class_2561)ADD_BUTTON_TEXT, b -> this.addCurrentAccount()).method_46434(listX, buttonY, listWidth / 2 - 2, buttonHeight).method_46431());
        this.removeButton = class_4185.method_46430((class_2561)REMOVE_BUTTON_TEXT, b -> this.removeSelectedAccount()).method_46434(listX + listWidth / 2 + 2, buttonY, listWidth / 2 - 2, buttonHeight).method_46431();
        this.method_37063((class_364)this.removeButton);
        this.accountList.updateButtonStates = this::updateButtonStates;
        this.accountList.setSelected(this.accountList.method_25396().stream().filter(e -> e.username.equals(class_310.method_1551().method_1548().method_1676())).findFirst().orElse(null));
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.removeButton != null) {
            this.removeButton.field_22763 = this.accountList != null && this.accountList.method_25334() != null;
        }
    }

    private void addCurrentAccount() {
        String name = this.usernameField.method_1882().trim();
        if (name.isEmpty() || !USERNAME_PATTERN.matcher(name).matches()) {
            this.statusMessage = class_2561.method_43470((String)"Invalid username to save.");
            this.statusColor = 0xFF0000;
            return;
        }
        if (!SAVED_ACCOUNTS.contains(name)) {
            SAVED_ACCOUNTS.add(name);
            this.accountList.refreshList();
            LoginScreen.saveAccounts();
            this.statusMessage = class_2561.method_43470((String)("Added account: " + name));
            this.statusColor = 0x55FF55;
            LOGGER.info("Added new account to saved list: {}", (Object)name);
        } else {
            this.statusMessage = class_2561.method_43470((String)("Account " + name + " is already saved."));
            this.statusColor = 0xFFAAAA;
        }
    }

    private void removeSelectedAccount() {
        AccountList.AccountEntry selected = (AccountList.AccountEntry)this.accountList.method_25334();
        if (selected != null) {
            SAVED_ACCOUNTS.remove(selected.username);
            this.accountList.refreshList();
            LoginScreen.saveAccounts();
            this.updateButtonStates();
            this.statusMessage = class_2561.method_43470((String)("Removed account: " + selected.username));
            this.statusColor = 0xFFAAAA;
            LOGGER.info("Removed account from saved list: {}", (Object)selected.username);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics);
        graphics.method_27534(this.field_22793, TITLE, this.field_22789 / 2, 10, 0xFFFFFF);
        if (this.usernameField != null) {
            int n = this.usernameField.method_46427();
            Objects.requireNonNull(this.field_22793);
            int statusY = n - 9 - 2;
            graphics.method_27534(this.field_22793, this.statusMessage, this.field_22789 / 2, statusY, this.statusColor);
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    private void renderBackground(class_332 graphics) {
    }

    private static void saveAccounts() {
        try (FileWriter writer = new FileWriter(ACCOUNTS_FILE);){
            GSON.toJson(SAVED_ACCOUNTS, (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save accounts", (Throwable)e);
        }
    }

    private static void loadAccounts() {
        if (!ACCOUNTS_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(ACCOUNTS_FILE);){
            Type type = new TypeToken<List<String>>(){}.getType();
            List loaded = (List)GSON.fromJson((Reader)reader, type);
            if (loaded != null) {
                SAVED_ACCOUNTS.clear();
                SAVED_ACCOUNTS.addAll(loaded);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load accounts", (Throwable)e);
        }
    }

    private void updateStatusMessage() {
        String name = this.usernameField.method_1882().trim();
        if (name.isEmpty()) {
            this.statusMessage = class_2561.method_43470((String)"Enter a username to login or add.");
            this.statusColor = 0xFFAAAA;
            this.loginButton.field_22763 = false;
        } else if (!USERNAME_PATTERN.matcher(name).matches()) {
            this.statusMessage = class_2561.method_43470((String)"Username must be 3-16 chars, alphanumeric/underscore.");
            this.statusColor = 0xFFAAAA;
            this.loginButton.field_22763 = false;
        } else {
            this.statusMessage = class_2561.method_43473();
            this.statusColor = 0xFFFFFF;
            this.loginButton.field_22763 = true;
        }
    }

    private void attemptLogin(String name) {
        this.updateStatusMessage();
        if (this.statusMessage.getString().isEmpty() && !name.isEmpty()) {
            this.switchAccount(name);
        } else {
            this.statusMessage = class_2561.method_43470((String)"Fix the errors above to login.");
            this.statusColor = 0xFF0000;
        }
    }

    private void switchAccount(String name) {
        class_310 mc = class_310.method_1551();
        try {
            UUID fakeUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes());
            class_320 newUser = new class_320(name, fakeUUID, "0", Optional.empty(), Optional.empty(), class_320.class_321.field_1990);
            Field userField = class_310.class.getDeclaredField("user");
            userField.setAccessible(true);
            userField.set(mc, newUser);
            this.statusMessage = class_2561.method_43470((String)("Switched to user: " + name));
            this.statusColor = 0x55FF55;
            mc.method_1507(this.parent);
        }
        catch (Exception e) {
            LOGGER.error("Failed to switch account", (Throwable)e);
            this.statusMessage = class_2561.method_43470((String)"ERROR: Account switch failed.");
            this.statusColor = 0xFF0000;
        }
    }

    public class AccountList
    extends class_4280<AccountEntry> {
        public Runnable updateButtonStates;
        private long nextClickTime;

        public AccountList(class_310 mc, int width, int height, int y, int itemHeight) {
            super(mc, width, height, y, height + y, itemHeight);
            this.refreshList();
        }

        public void refreshList() {
            this.method_25339();
            for (String username : SAVED_ACCOUNTS) {
                this.method_25321((class_350.class_351)new AccountEntry(username));
            }
        }

        public int method_25322() {
            return this.field_22758;
        }

        protected int getScrollbarPositionX() {
            return this.field_22758 / 2 + 100;
        }

        public void setSelected(AccountEntry entry) {
            super.method_25313((class_350.class_351)entry);
            if (entry != null && LoginScreen.this.usernameField != null) {
                LoginScreen.this.usernameField.method_1852(entry.username);
                if (this.updateButtonStates != null) {
                    this.updateButtonStates.run();
                }
                LoginScreen.this.updateStatusMessage();
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean result = super.method_25402(mouseX, mouseY, button);
            if (result && button == 0 && this.method_25334() != null) {
                if (System.currentTimeMillis() - this.nextClickTime < 250L) {
                    LoginScreen.this.attemptLogin(((AccountEntry)this.method_25334()).username);
                }
                this.nextClickTime = System.currentTimeMillis();
            }
            return result;
        }

        public class AccountEntry
        extends class_4280.class_4281<AccountEntry> {
            private final String username;

            public AccountEntry(String username) {
                this.username = username;
            }

            public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                class_327 class_3272 = LoginScreen.this.field_22793;
                int n = x + entryWidth / 2;
                int n2 = y + entryHeight / 2;
                Objects.requireNonNull(LoginScreen.this.field_22793);
                graphics.method_25300(class_3272, this.username, n, n2 - 9 / 2, 0xFFFFFF);
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)this.username);
            }
        }
    }
}

