/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class ModrinthDownloaderScreen
extends class_437 {
    private static final Logger LOGGER = Logger.getLogger(ModrinthDownloaderScreen.class.getName());
    private static final ExecutorService networkExecutor = Executors.newFixedThreadPool(10);
    private static final class_2960 DEFAULT_ICON = class_2960.method_60655((String)"feather_remake", (String)"textures/misc/unknown_pack.png");
    private class_342 searchBox;
    private String searchQuery = "";
    private Category currentCategory = Category.MODS;
    private final List<JsonObject> items = new ArrayList<JsonObject>();
    private final Map<String, class_2960> iconCache = new ConcurrentHashMap<String, class_2960>();
    private final Set<String> iconsBeingLoaded = new HashSet<String>();
    private JsonObject selectedItem;
    private List<JsonObject> availableVersions = new ArrayList<JsonObject>();
    private boolean isLoadingVersions = false;
    private int scrollOffset = 0;
    private boolean isLoading = false;
    private String statusMessage = "";
    private long statusMessageTime = 0L;
    private int currentPage = 0;
    private boolean hasMorePages = true;

    public ModrinthDownloaderScreen() {
        super((class_2561)class_2561.method_43470((String)"Download from Modrinth"));
    }

    protected void method_25426() {
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 100, 22, 200, 20, (class_2561)class_2561.method_43470((String)"Search..."));
        this.searchBox.method_1863(query -> {
            this.searchQuery = query;
            this.scrollOffset = 0;
        });
        this.method_37063((class_364)this.searchBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), b -> this.method_25419()).method_46433(10, this.field_22790 - 30).method_46437(60, 20).method_46431());
        this.loadItemsForCategory(this.currentCategory);
    }

    private void loadItemsForCategory(Category category) {
        this.currentCategory = category;
        this.items.clear();
        this.currentPage = 0;
        this.hasMorePages = true;
        this.scrollOffset = 0;
        this.selectedItem = null;
        this.availableVersions.clear();
        this.loadItems(0);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        int listWidth = this.field_22789 / 2 - 20;
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        this.renderTabs(graphics, mouseX, mouseY);
        this.renderItemList(graphics, mouseX, mouseY, listWidth);
        this.renderScrollbar(graphics, listWidth);
        this.renderDetailsPane(graphics, mouseX, mouseY, listWidth);
        if (!this.statusMessage.isEmpty() && System.currentTimeMillis() - this.statusMessageTime < 5000L) {
            graphics.method_25294(0, this.field_22790 - 14, this.field_22789, this.field_22790, -587202560);
            graphics.method_25303(this.field_22793, this.statusMessage, 5, this.field_22790 - 10, 65280);
        }
    }

    private void renderTabs(class_332 graphics, int mouseX, int mouseY) {
        int tabX = 20;
        int tabY = 45;
        int tabWidth = 100;
        int tabHeight = 20;
        for (Category cat : Category.values()) {
            boolean isHovered;
            boolean isSelected = cat == this.currentCategory;
            boolean bl = isHovered = mouseX >= tabX && mouseX <= tabX + tabWidth && mouseY >= tabY && mouseY <= tabY + tabHeight;
            int bgColor = isSelected ? -16746497 : (isHovered ? -11184811 : -13421773);
            graphics.method_25294(tabX, tabY, tabX + tabWidth, tabY + tabHeight, bgColor);
            graphics.method_25300(this.field_22793, cat.name(), tabX + tabWidth / 2, tabY + 6, 0xFFFFFF);
            tabX += tabWidth + 5;
        }
    }

    private void renderItemList(class_332 graphics, int mouseX, int mouseY, int listWidth) {
        int itemY = 70;
        int itemHeight = 50;
        int startX = 20;
        List<JsonObject> filteredItems = this.getFilteredItems();
        for (int i = this.scrollOffset; i < filteredItems.size() && itemY <= this.field_22790 - 40; itemY += itemHeight + 5, ++i) {
            boolean isHovered;
            JsonObject item = filteredItems.get(i);
            String title = item.get("title").getAsString();
            String description = item.get("description").getAsString();
            String author = item.get("author").getAsString();
            boolean bl = isHovered = mouseX >= startX && mouseX <= startX + listWidth && mouseY >= itemY && mouseY <= itemY + itemHeight;
            int bgColor = this.selectedItem != null && this.selectedItem.get("project_id").getAsString().equals(item.get("project_id").getAsString()) ? -1442809857 : (isHovered ? 0x44FFFFFF : 0x22FFFFFF);
            graphics.method_25294(startX, itemY, startX + listWidth, itemY + itemHeight, bgColor);
            class_2960 icon = DEFAULT_ICON;
            if (item.has("icon_url") && !item.get("icon_url").isJsonNull()) {
                String iconUrl = item.get("icon_url").getAsString();
                if (this.iconCache.containsKey(iconUrl)) {
                    icon = this.iconCache.get(iconUrl);
                } else {
                    this.loadIconAsync(iconUrl);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_25290(class_1921::method_62275, icon, startX + 5, itemY + 5, 0.0f, 0.0f, 40, 40, 40, 40);
            graphics.method_25303(this.field_22793, title, startX + 50, itemY + 8, 0xFFFFFF);
            graphics.method_25303(this.field_22793, "by " + author, startX + 50, itemY + 20, 0xAAAAAA);
            graphics.method_25303(this.field_22793, description.substring(0, Math.min(description.length(), 50)) + "...", startX + 50, itemY + 32, 0x888888);
        }
        if (this.isLoading) {
            graphics.method_25300(this.field_22793, "Loading...", startX + listWidth / 2, this.field_22790 / 2, 0xFFFFFF);
        }
    }

    private void renderScrollbar(class_332 graphics, int listWidth) {
        int startX = 20;
        int topY = 70;
        int bottomY = this.field_22790 - 40;
        int scrollbarX = startX + listWidth + 2;
        int listHeight = bottomY - topY;
        int filteredCount = this.getFilteredItems().size();
        if (filteredCount == 0) {
            return;
        }
        int contentHeight = filteredCount * 55;
        if (contentHeight <= listHeight) {
            return;
        }
        graphics.method_25294(scrollbarX, topY, scrollbarX + 4, bottomY, -14540254);
        int handleHeight = Math.max(20, (int)((float)listHeight / (float)contentHeight * (float)listHeight));
        int handleY = topY + (int)((float)(this.scrollOffset * 55) / (float)contentHeight * (float)listHeight);
        graphics.method_25294(scrollbarX, handleY, scrollbarX + 4, handleY + handleHeight, -7829368);
    }

    private void renderDetailsPane(class_332 graphics, int mouseX, int mouseY, int listWidth) {
        int startX = listWidth + 30;
        int topY = 70;
        if (this.selectedItem == null) {
            graphics.method_25300(this.field_22793, "Select an item to see details", startX + (this.field_22789 - startX) / 2, this.field_22790 / 2, 0xAAAAAA);
            return;
        }
        String title = this.selectedItem.get("title").getAsString();
        String description = this.selectedItem.get("description").getAsString();
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)title).method_27692(class_124.field_1067), startX, topY, 0xFFFFFF);
        graphics.method_65179(this.field_22793, (class_5348)class_2561.method_43470((String)description), startX, topY + 15, this.field_22789 - startX - 20, 0xCCCCCC);
        int versionsY = topY + 80;
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Versions").method_27692(class_124.field_1054), startX, versionsY, 0xFFFFFF);
        graphics.method_25294(startX, versionsY + 12, this.field_22789 - 20, versionsY + 13, -11184811);
        if (this.isLoadingVersions) {
            graphics.method_25303(this.field_22793, "Loading versions...", startX, versionsY + 20, 0xAAAAAA);
        } else {
            int versionEntryY = versionsY + 20;
            String mcVersion = class_310.method_1551().method_1515();
            for (JsonObject version : this.availableVersions) {
                if (versionEntryY > this.field_22790 - 40) break;
                String name = version.get("name").getAsString();
                String loaders = version.getAsJsonArray("loaders").toString();
                JsonArray gameVersions = version.getAsJsonArray("game_versions");
                boolean isCompatible = false;
                for (JsonElement gv : gameVersions) {
                    if (!gv.getAsString().equals(mcVersion)) continue;
                    isCompatible = true;
                }
                boolean isHovered = mouseX >= startX && mouseX <= this.field_22789 - 20 && mouseY >= versionEntryY && mouseY <= versionEntryY + 20;
                graphics.method_25294(startX, versionEntryY, this.field_22789 - 20, versionEntryY + 20, isHovered ? 0x33FFFFFF : 0);
                graphics.method_25303(this.field_22793, name, startX + 5, versionEntryY + 6, isCompatible ? 0x55FF55 : 0xFFFFFF);
                graphics.method_25303(this.field_22793, gameVersions.toString(), startX + 120, versionEntryY + 6, 0xAAAAAA);
                int downloadBtnX = this.field_22789 - 80;
                boolean downloadHover = mouseX >= downloadBtnX && mouseX <= downloadBtnX + 50 && mouseY >= versionEntryY + 2 && mouseY <= versionEntryY + 18;
                graphics.method_25294(downloadBtnX, versionEntryY + 2, downloadBtnX + 50, versionEntryY + 18, downloadHover ? -16733441 : -16746497);
                graphics.method_25300(this.field_22793, "Install", downloadBtnX + 25, versionEntryY + 6, 0xFFFFFF);
                versionEntryY += 22;
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        int tabX = 20;
        for (Category cat : Category.values()) {
            if (mouseX >= (double)tabX && mouseX <= (double)(tabX + 100) && mouseY >= 45.0 && mouseY <= 65.0) {
                if (cat != this.currentCategory) {
                    this.loadItemsForCategory(cat);
                }
                return true;
            }
            tabX += 105;
        }
        int itemY = 70;
        int listWidth = this.field_22789 / 2 - 20;
        List<JsonObject> filteredItems = this.getFilteredItems();
        for (int i = this.scrollOffset; i < filteredItems.size() && itemY <= this.field_22790 - 40; itemY += 55, ++i) {
            if (!(mouseX >= 20.0) || !(mouseX <= (double)(20 + listWidth)) || !(mouseY >= (double)itemY) || !(mouseY <= (double)(itemY + 50))) continue;
            this.selectedItem = filteredItems.get(i);
            this.loadItemVersions(this.selectedItem.get("project_id").getAsString());
            return true;
        }
        if (this.selectedItem != null && !this.isLoadingVersions) {
            int versionsY = 170;
            int startX = this.field_22789 / 2 - 20 + 30;
            for (JsonObject version : this.availableVersions) {
                if (versionsY > this.field_22790 - 40) break;
                int downloadBtnX = this.field_22789 - 80;
                if (mouseX >= (double)downloadBtnX && mouseX <= (double)(downloadBtnX + 50) && mouseY >= (double)(versionsY + 2) && mouseY <= (double)(versionsY + 18)) {
                    this.confirmInstall(this.selectedItem, version);
                    return true;
                }
                versionsY += 22;
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        int listWidth = this.field_22789 / 2 - 20;
        if (mouseX < (double)listWidth) {
            int newOffset = this.scrollOffset - (int)scrollY;
            int maxScroll = Math.max(0, this.getFilteredItems().size() - (this.field_22790 - 110) / 55);
            this.scrollOffset = Math.max(0, Math.min(newOffset, maxScroll));
            if (scrollY < 0.0 && maxScroll - this.scrollOffset < 2 && this.hasMorePages && !this.isLoading) {
                this.loadItems(this.currentPage + 1);
            }
            return true;
        }
        return false;
    }

    private List<JsonObject> getFilteredItems() {
        if (this.searchQuery.isEmpty()) {
            return this.items;
        }
        String lowerQuery = this.searchQuery.toLowerCase(Locale.ROOT);
        return this.items.stream().filter(item -> item.get("title").getAsString().toLowerCase(Locale.ROOT).contains(lowerQuery)).collect(Collectors.toList());
    }

    private void setStatus(String message) {
        this.statusMessage = message;
        this.statusMessageTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIconAsync(String url) {
        Set<String> set = this.iconsBeingLoaded;
        synchronized (set) {
            if (this.iconCache.containsKey(url) || this.iconsBeingLoaded.contains(url)) {
                return;
            }
            this.iconsBeingLoaded.add(url);
        }
        networkExecutor.submit(() -> {
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                conn.setRequestProperty("User-Agent", "FeatherRemake/1.0 (contact@example.com)");
                try (InputStream in = conn.getInputStream();){
                    BufferedImage bufferedImage = null;
                    try {
                        Class.forName("com.twelvemonkeys.imageio.plugins.webp.WebPImageReaderSpi").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        IIORegistry.getDefaultInstance().registerServiceProvider((ImageReaderSpi)Class.forName("com.twelvemonkeys.imageio.plugins.webp.WebPImageReaderSpi").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    bufferedImage = ImageIO.read(in);
                    if (bufferedImage == null) {
                        throw new IOException("Failed to decode image: " + url);
                    }
                    class_1011 nativeImage = this.convertToNativeImage(bufferedImage);
                    class_310.method_1551().execute(() -> this.registerTexture(url, nativeImage));
                }
            }
            catch (Exception e) {
                LOGGER.warning("Failed to load icon " + url + ": " + e.getMessage());
                class_310.method_1551().execute(() -> {
                    block23: {
                        try {
                            Object fallbackLoc = class_2960.method_60655((String)"feather_remake", (String)"textures/icons/failed.png");
                            Optional optResource = class_310.method_1551().method_1478().method_14486(fallbackLoc);
                            if (optResource.isPresent()) {
                                try (InputStream assetStream = ((class_3298)optResource.get()).method_14482();){
                                    BufferedImage fallbackImage = ImageIO.read(assetStream);
                                    if (fallbackImage != null) {
                                        class_1011 nativeImage = this.convertToNativeImage(fallbackImage);
                                        this.registerTexture(url, nativeImage);
                                    } else {
                                        LOGGER.warning("Failed to decode fallback icon: " + String.valueOf(fallbackLoc));
                                    }
                                    break block23;
                                }
                            }
                            LOGGER.warning("Fallback icon not found: " + String.valueOf(fallbackLoc));
                        }
                        catch (IOException ex) {
                            LOGGER.warning("Failed to load fallback icon: " + ex.getMessage());
                        }
                        finally {
                            Set<String> set = this.iconsBeingLoaded;
                            synchronized (set) {
                                this.iconsBeingLoaded.remove(url);
                            }
                        }
                    }
                });
                return;
            }
            Set<String> set = this.iconsBeingLoaded;
            synchronized (set) {
                this.iconsBeingLoaded.remove(url);
            }
        });
    }

    private class_1011 convertToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        class_1011 nativeImage = new class_1011(width, height, true);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = bufferedImage.getRGB(x, y);
                nativeImage.method_61941(x, y, argb);
            }
        }
        return nativeImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTexture(String url, class_1011 nativeImage) {
        class_1043 dynamicTexture = new class_1043(() -> "modrinth_icon_" + url.hashCode(), nativeImage);
        dynamicTexture.method_4524();
        class_2960 location = class_2960.method_60655((String)"feather_remake", (String)("modicon_" + url.hashCode()));
        class_310.method_1551().method_1531().method_4616(location, (class_1044)dynamicTexture);
        this.iconCache.put(url, location);
        Set<String> set = this.iconsBeingLoaded;
        synchronized (set) {
            this.iconsBeingLoaded.remove(url);
        }
    }

    private void loadItems(int page) {
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        networkExecutor.submit(() -> {
            block14: {
                try {
                    String categoryStr = switch (this.currentCategory.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> "mod";
                        case 1 -> "shader";
                        case 2 -> "resourcepack";
                    };
                    String facets = URLEncoder.encode("[[\"project_type:" + categoryStr + "\"]]", StandardCharsets.UTF_8);
                    String url = String.format("https://api.modrinth.com/v2/search?limit=20&offset=%d&facets=%s", page * 20, facets);
                    HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                    conn.setRequestProperty("User-Agent", "FeatherRemake/1.0");
                    if (conn.getResponseCode() == 200) {
                        try (InputStream is = conn.getInputStream();){
                            String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                            JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
                            JsonArray hits = obj.getAsJsonArray("hits");
                            int totalHits = obj.get("total_hits").getAsInt();
                            class_310.method_1551().execute(() -> {
                                hits.forEach(element -> this.items.add(element.getAsJsonObject()));
                                this.currentPage = page;
                                this.hasMorePages = this.items.size() < totalHits;
                                this.isLoading = false;
                            });
                            break block14;
                        }
                    }
                    this.setStatus("Failed to load items: HTTP " + conn.getResponseCode());
                    this.isLoading = false;
                }
                catch (Exception e) {
                    LOGGER.severe("Error loading items: " + e.getMessage());
                    this.setStatus("Error: " + e.getMessage());
                    this.isLoading = false;
                }
            }
        });
    }

    private void loadItemVersions(String projectId) {
        this.isLoadingVersions = true;
        this.availableVersions.clear();
        networkExecutor.submit(() -> {
            block9: {
                try {
                    String url = "https://api.modrinth.com/v2/project/" + projectId + "/version";
                    HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                    conn.setRequestProperty("User-Agent", "FeatherRemake/1.0");
                    if (conn.getResponseCode() == 200) {
                        try (InputStream is = conn.getInputStream();){
                            JsonArray versionsArray = JsonParser.parseString((String)new String(is.readAllBytes(), StandardCharsets.UTF_8)).getAsJsonArray();
                            ArrayList versions = new ArrayList();
                            versionsArray.forEach(v -> versions.add(v.getAsJsonObject()));
                            class_310.method_1551().execute(() -> {
                                this.availableVersions = versions;
                                this.isLoadingVersions = false;
                            });
                            break block9;
                        }
                    }
                    this.setStatus("Failed to get versions: HTTP " + conn.getResponseCode());
                    this.isLoadingVersions = false;
                }
                catch (Exception e) {
                    LOGGER.severe("Error loading versions: " + e.getMessage());
                    this.setStatus("Error loading versions: " + e.getMessage());
                    this.isLoadingVersions = false;
                }
            }
        });
    }

    private void confirmInstall(JsonObject item, JsonObject version) {
        String title = item.get("title").getAsString();
        String verName = version.get("name").getAsString();
        this.field_22787.method_1507((class_437)new class_410(doInstall -> {
            if (doInstall) {
                this.installItem(version);
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)class_2561.method_43470((String)("Install " + title)), (class_2561)class_2561.method_43470((String)("Are you sure you want to download version '" + verName + "'?"))));
    }

    private void installItem(JsonObject version) {
        JsonArray files = version.getAsJsonArray("files");
        if (files.isEmpty()) {
            this.setStatus("Error: Selected version has no files.");
            return;
        }
        JsonObject fileToDownload = files.get(0).getAsJsonObject();
        for (JsonElement file : files) {
            if (!file.getAsJsonObject().get("primary").getAsBoolean()) continue;
            fileToDownload = file.getAsJsonObject();
            break;
        }
        String downloadUrl = fileToDownload.get("url").getAsString();
        String fileName = fileToDownload.get("filename").getAsString();
        Path targetDir = switch (this.currentCategory.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.field_22787.field_1697.toPath().resolve("mods");
            case 1 -> this.field_22787.field_1697.toPath().resolve("shaderpacks");
            case 2 -> this.field_22787.field_1697.toPath().resolve("resourcepacks");
        };
        this.setStatus("Starting download of " + fileName);
        networkExecutor.submit(() -> {
            try {
                Files.createDirectories(targetDir, new FileAttribute[0]);
                HttpURLConnection conn = (HttpURLConnection)new URL(downloadUrl).openConnection();
                conn.setRequestProperty("User-Agent", "FeatherRemake/1.0");
                long totalSize = conn.getContentLengthLong();
                try (InputStream in = conn.getInputStream();
                     FileOutputStream out = new FileOutputStream(targetDir.resolve(fileName).toFile());){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    long downloaded = 0L;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                        downloaded += (long)bytesRead;
                        if (totalSize <= 0L) continue;
                        int progress = (int)(downloaded * 100L / totalSize);
                        this.setStatus("Downloading " + fileName + "... " + progress + "%");
                    }
                }
                this.setStatus("Successfully installed " + fileName);
            }
            catch (Exception e) {
                LOGGER.severe("Failed to download " + fileName + ": " + e.getMessage());
                this.setStatus("Download failed: " + e.getMessage());
            }
        });
    }

    public void method_25419() {
        super.method_25419();
    }

    private static enum Category {
        MODS,
        SHADERS,
        RESOURCEPACKS;

    }
}

