/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.gui;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public final class ScreenPreviewScreen
extends class_437 {
    private static final int THUMB_W = 160;
    private static final int THUMB_H = 90;
    private static final int PADDING = 12;
    private static final int TOP_PAD = 30;
    private final List<Entry> entries = new ArrayList<Entry>();
    private float scrollY = 0.0f;
    private float scrollTargetY = 0.0f;
    private int columns = 1;
    private int contentHeight = 0;
    private Entry fullscreenEntry = null;

    public ScreenPreviewScreen() {
        super((class_2561)class_2561.method_43470((String)"Manage Screenshots.."));
    }

    protected void method_25426() {
        this.entries.clear();
        this.scrollY = 0.0f;
        this.scrollTargetY = 0.0f;
        Path screenshotsDir = class_310.method_1551().field_1697.toPath().resolve("screenshots");
        if (Files.isDirectory(screenshotsDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(screenshotsDir);){
                stream.filter(p -> p.getFileName().toString().toLowerCase().endsWith(".png")).sorted(Comparator.comparing(p -> {
                    try {
                        return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }).reversed()).forEach(this::loadEntry);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), b -> this.method_25419()).method_46433(this.field_22789 / 2 - 40, this.field_22790 - 30).method_46437(80, 20).method_46431());
        this.computeLayout();
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.computeLayout();
    }

    private void computeLayout() {
        int availableW = this.field_22789 - 24;
        this.columns = Math.max(1, availableW / 172);
        int rows = (int)Math.ceil((double)this.entries.size() / (double)this.columns);
        Objects.requireNonNull(this.field_22793);
        this.contentHeight = 30 + rows * (102 + 9 * 2) + 12;
    }

    private void loadEntry(Path file) {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            class_1011 img = class_1011.method_4309((InputStream)in);
            class_1043 dyn = new class_1043(() -> "screenshot_" + file.getFileName().toString(), img);
            String safeName = file.getFileName().toString().replaceAll("[^a-zA-Z0-9._-]", "_");
            String unique = safeName + "_" + Integer.toHexString(file.toAbsolutePath().toString().hashCode());
            class_2960 id = class_2960.method_60655((String)"screenshotgallery", (String)("screenshot/" + unique));
            class_310.method_1551().method_1531().method_4616(id, (class_1044)dyn);
            this.entries.add(new Entry(file, id, dyn, img.method_4307(), img.method_4323()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.fullscreenEntry != null) {
            return false;
        }
        int viewH = this.field_22790 - 30 - 12;
        int maxScroll = Math.max(0, this.contentHeight - viewH);
        this.scrollTargetY = class_3532.method_15363((float)(this.scrollTargetY - (float)delta * 60.0f), (float)0.0f, (float)maxScroll);
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.fullscreenEntry != null) {
            this.fullscreenEntry = null;
            return true;
        }
        int x0 = 12;
        int y0 = (int)(30.0f - this.scrollY);
        for (int i = 0; i < this.entries.size(); ++i) {
            int col = i % this.columns;
            int row = i / this.columns;
            int x = x0 + col * 172;
            Objects.requireNonNull(this.field_22793);
            int y = y0 + row * (102 + 9 * 2);
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 160)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 90))) continue;
            this.fullscreenEntry = this.entries.get(i);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float delta) {
        this.method_25420(g, mouseX, mouseY, delta);
        this.scrollY += (this.scrollTargetY - this.scrollY) * 0.2f;
        if (this.fullscreenEntry != null) {
            this.renderFullscreen(g, this.fullscreenEntry);
        } else {
            this.renderThumbnails(g, mouseX, mouseY);
        }
        super.method_25394(g, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 g, int mouseX, int mouseY, float delta) {
        g.method_25296(0, 0, this.field_22789, this.field_22790, -1341124592, -536870912);
    }

    private void renderThumbnails(class_332 g, int mouseX, int mouseY) {
        g.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, 0xFFFFFF);
        int x0 = 12;
        int y0 = (int)(30.0f - this.scrollY);
        int viewTop = 30;
        int viewBottom = this.field_22790 - 40;
        for (int i = 0; i < this.entries.size(); ++i) {
            int drawH;
            int drawW;
            float boxAspect;
            int col = i % this.columns;
            int row = i / this.columns;
            int x = x0 + col * 172;
            Objects.requireNonNull(this.field_22793);
            int y = y0 + row * (102 + 9 * 2);
            if (y + 90 < viewTop || y > viewBottom) continue;
            Entry e = this.entries.get(i);
            float imgAspect = (float)e.imgW() / (float)e.imgH();
            if (imgAspect > (boxAspect = 1.7777778f)) {
                drawW = 160;
                drawH = (int)(160.0f / imgAspect);
            } else {
                drawH = 90;
                drawW = (int)(90.0f * imgAspect);
            }
            int dx = x + (160 - drawW) / 2;
            int dy = y + (90 - drawH) / 2;
            boolean hovered = mouseX >= x && mouseX <= x + 160 && mouseY >= y && mouseY <= y + 90;
            int borderColor = hovered ? -16732433 : -1438366652;
            g.method_25290(class_1921::method_62277, e.id(), dx, dy, 0.0f, 0.0f, drawW, drawH, e.imgW(), e.imgH());
            g.method_49601(x - 1, y - 1, 162, 92, borderColor);
            String fileName = e.file().getFileName().toString();
            int textColor = hovered ? -1 : -1426063361;
            g.method_25300(this.field_22793, fileName, x + 80, y + 90 + 4, textColor);
        }
    }

    private void renderFullscreen(class_332 g, Entry e) {
        int screenW = this.field_22789;
        int screenH = this.field_22790;
        float scaleX = (float)screenW / (float)e.imgW();
        float scaleY = (float)screenH / (float)e.imgH();
        float scale = Math.min(scaleX, scaleY);
        int drawW = (int)((float)e.imgW() * scale);
        int drawH = (int)((float)e.imgH() * scale);
        int dx = (screenW - drawW) / 2;
        int dy = (screenH - drawH) / 2;
        g.method_25296(0, 0, screenW, screenH, -536870912, -536870912);
        g.method_25290(class_1921::method_62277, e.id(), dx, dy, 0.0f, 0.0f, drawW, drawH, e.imgW(), e.imgH());
    }

    public void method_25419() {
        this.releaseTextures();
        super.method_25419();
    }

    public void method_25432() {
        this.releaseTextures();
        super.method_25432();
    }

    private void releaseTextures() {
        class_1060 texMgr = class_310.method_1551().method_1531();
        for (Entry e : this.entries) {
            texMgr.method_4615(e.id());
            e.dynamic().close();
        }
        this.entries.clear();
    }

    public record Entry(Path file, class_2960 id, class_1043 dynamic, int imgW, int imgH) {
    }
}

