/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.gui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.ashmeetop.feather_remake.client.config.TintConfig;
import org.ashmeetop.feather_remake.client.gui.LogoSelectorScreen;
import org.ashmeetop.feather_remake.client.gui.SliderButton;
import org.ashmeetop.feather_remake.client.gui.element.DynamicHueButton;

public class TintSettingsScreen
extends class_437 {
    private static final List<DynamicHueButton> REGISTERED_BUTTONS = new ArrayList<DynamicHueButton>();
    private static float hue = TintConfig.get().hue;
    private final class_437 parent;
    private static final String PACK_NAME = "custom_hidden_pack.zip";
    private DynamicHueButton previewButton;

    public TintSettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Color Settings"));
        this.parent = parent;
    }

    public static void registerButton(DynamicHueButton button) {
        REGISTERED_BUTTONS.add(button);
    }

    public static float getHue() {
        return hue;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int startY = this.field_22790 / 4;
        this.method_37063((class_364)new SliderButton(centerX - 100, startY, 200, 20, "Hue", (int)(hue * 255.0f), value -> {
            hue = (float)value / 255.0f;
            this.updateButtonHues();
            TintConfig.get().hue = hue;
            TintConfig.save();
        }));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Select Logo"), btn -> class_310.method_1551().method_1507((class_437)new LogoSelectorScreen())).method_46434(centerX - 100, startY + 30, 200, 20).method_46431());
        int boxSize = Math.max(40, this.field_22789 / 20);
        int previewX = this.field_22789 / 2 - boxSize / 2;
        int previewY = this.field_22790 - boxSize - 40;
        this.previewButton = new DynamicHueButton(previewX, previewY, boxSize, boxSize, 0, 0, (class_2561)class_2561.method_43470((String)"Preview"), btn -> {}, class_2960.method_60655((String)"feather_remake", (String)"textures/gui/color.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/color.png"), hue, 1.0f);
        this.method_37063((class_364)this.previewButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), btn -> this.method_25419()).method_46434(centerX - 100, startY + 90, 200, 20).method_46431());
    }

    private void updateButtonHues() {
        for (DynamicHueButton button : REGISTERED_BUTTONS) {
            button.setTargetHueShift(hue);
            button.getCurrentHueShift();
        }
        if (this.previewButton != null) {
            this.previewButton.setTargetHueShift(hue);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -1442840576);
        graphics.method_25300(this.field_22793, "Adjust Button Hue", this.field_22789 / 2, this.field_22790 / 10, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public void method_25419() {
        TintConfig.get().hue = hue;
        TintConfig.save();
        class_310.method_1551().method_1507(this.parent);
        super.method_25419();
    }

    private void enableCustomTexturePack() {
        class_310 mc = class_310.method_1551();
        Path target = mc.field_1697.toPath().resolve("resourcepacks").resolve(PACK_NAME);
        Path source = Paths.get("assets/feather_remake/resourcepacks/custom_hidden_pack.zip", new String[0]);
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            class_3283 repo = mc.method_1520();
            ArrayList<String> enabled = new ArrayList<String>(repo.method_29210());
            if (!enabled.contains(PACK_NAME)) {
                enabled.add(PACK_NAME);
                repo.method_14447(enabled);
                mc.method_1521();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void disableCustomTexturePack() {
        class_310 mc = class_310.method_1551();
        Path target = mc.field_1697.toPath().resolve("resourcepacks").resolve(PACK_NAME);
        class_3283 repo = mc.method_1520();
        ArrayList enabled = new ArrayList(repo.method_29210());
        enabled.remove(PACK_NAME);
        repo.method_14447(enabled);
        mc.method_1521();
        try {
            Files.deleteIfExists(target);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void disableDarkMode() {
        TintConfig.get().darkMode = false;
        TintConfig.save();
    }

    private void enableDarkMode() {
        TintConfig.get().darkMode = true;
        TintConfig.save();
    }
}

