/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.gui;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class WebpLibraryInstallerScreen
extends class_437 {
    private static final class_2960 BACKGROUND = class_2960.method_60655((String)"lunar_remake", (String)"textures/gui/menu_bg.png");
    private static final String WEBP_URL = "https://repo1.maven.org/maven2/com/twelvemonkeys/imageio/imageio-webp/3.12.0/imageio-webp-3.12.0.jar";
    private static final String FILE_NAME = "imageio-webp-3.12.0.jar";
    private final class_437 previousScreen;
    private String status = "Checking WebP support...";
    private class_4185 installButton;
    private boolean installing = false;

    public WebpLibraryInstallerScreen(class_437 previousScreen) {
        super((class_2561)class_2561.method_43470((String)"WebP Library Installer"));
        this.previousScreen = previousScreen;
    }

    protected void method_25426() {
        int cx = this.field_22789 / 2;
        int cy = this.field_22790 / 2;
        this.installButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Install WebP Support"), button -> {
            button.field_22763 = false;
            this.installing = true;
            this.status = "Downloading WebP decoder...";
            this.downloadAndInstall();
        }).method_46434(cx - 75, cy + 40, 150, 20).method_46431();
        this.method_37063((class_364)this.installButton);
        super.method_25426();
        new Thread(() -> {
            if (this.isWebpSupported()) {
                this.status = "WebP already supported \u2014 loading icons!";
                class_310.method_1551().execute(() -> this.field_22787.method_1507(this.previousScreen));
            } else {
                this.status = "WebP decoding not available.";
            }
        }).start();
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float delta) {
        int cx = this.field_22789 / 2;
        int cy = this.field_22790 / 2;
        g.method_25300(this.field_22793, "Enable WebP Image Support", cx, cy - 60, 0xFFFFFF);
        g.method_25300(this.field_22793, "Some mod icons use .webp textures.", cx, cy - 40, 0xAAAAAA);
        g.method_25300(this.field_22793, "Install the decoder to display them correctly.", cx, cy - 28, 0xAAAAAA);
        g.method_25300(this.field_22793, this.status, cx, cy, 65535);
        super.method_25394(g, mouseX, mouseY, delta);
    }

    private void downloadAndInstall() {
        new Thread(() -> {
            try {
                Path modsDir = class_310.method_1551().field_1697.toPath().resolve("mods");
                Files.createDirectories(modsDir, new FileAttribute[0]);
                Path outFile = modsDir.resolve(FILE_NAME);
                HttpURLConnection conn = (HttpURLConnection)new URL(WEBP_URL).openConnection();
                conn.setRequestProperty("User-Agent", "LunarRemake-WebPInstaller/1.0");
                if (conn.getResponseCode() != 200) {
                    throw new RuntimeException("HTTP " + conn.getResponseCode());
                }
                try (InputStream in = conn.getInputStream();
                     FileOutputStream out = new FileOutputStream(outFile.toFile());){
                    in.transferTo(out);
                }
                this.status = "WebP library installed successfully!";
                this.installing = false;
                class_310.method_1551().execute(() -> {
                    this.method_37066((class_364)this.installButton);
                    this.installButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Restart Minecraft"), b -> class_310.method_1551().method_1507(this.previousScreen)).method_46433(this.installButton.method_46426(), this.installButton.method_46427()).method_46437(this.installButton.method_25368(), this.installButton.method_25364()).method_46431();
                    this.method_37063((class_364)this.installButton);
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                class_310.method_1551().execute(() -> {
                    this.status = "Installation failed: " + e.getMessage();
                    this.installing = false;
                    this.installButton.field_22763 = true;
                    this.installButton.method_25355((class_2561)class_2561.method_43470((String)"Retry"));
                });
            }
        }).start();
    }

    private boolean isWebpSupported() {
        try {
            return ImageIO.getImageReadersByFormatName("webp").hasNext();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean method_25422() {
        return !this.installing;
    }
}

