/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.replaymod.replay.ReplayModReplay;
import com.replaymod.replay.gui.screen.GuiReplayViewer;
import com.terraformersmc.modmenu.gui.ModsScreen;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_429;
import net.minecraft.class_4325;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_526;
import net.minecraft.class_8685;
import org.ashmeetop.feather_remake.client.config.TintConfig;
import org.ashmeetop.feather_remake.client.cosmetics.CapeSelectionScreen;
import org.ashmeetop.feather_remake.client.gui.ErrorScreen;
import org.ashmeetop.feather_remake.client.gui.FeatherRemakeScreen;
import org.ashmeetop.feather_remake.client.gui.ModrinthDownloaderScreen;
import org.ashmeetop.feather_remake.client.gui.ScreenPreviewScreen;
import org.ashmeetop.feather_remake.client.gui.ServerSelectScreen;
import org.ashmeetop.feather_remake.client.gui.TintSettingsScreen;
import org.ashmeetop.feather_remake.client.gui.element.DynamicHueButton;
import org.ashmeetop.feather_remake.client.gui.element.SidebarWidget;
import org.ashmeetop.feather_remake.client.gui.element.TexturedButton;
import org.ashmeetop.feather_remake.client.gui.element.serverbtn;

public class feathertitlescreen
extends class_437 {
    private long screenOpenTime;
    private static final long FADE_IN_DURATION = 750L;
    private static final long FIREWORK_SPAWN_INTERVAL = 500L;
    private long lastFireworkSpawn = 0L;
    private final List<Firework> fireworks = new ArrayList<Firework>();
    private boolean diwaliActive = false;
    private class_2561 errorMessage = null;
    private long errorDisplayStartTime;
    private static final long ERROR_DISPLAY_DURATION = 3000L;

    public feathertitlescreen() {
        super((class_2561)class_2561.method_43470((String)"Feather Remake Client"));
    }

    private void renderFireworks(class_332 graphics, float delta) {
        if (!this.diwaliActive) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Random random = new Random();
        if (currentTime - this.lastFireworkSpawn > 500L) {
            this.lastFireworkSpawn = currentTime;
            float x = random.nextInt(this.field_22789);
            float y = this.field_22790 + 20;
            float velY = -3.0f - random.nextFloat() * 2.0f;
            float fuse = 50.0f + random.nextFloat() * 30.0f;
            int color = 0xFFFF50;
            this.fireworks.add(new Firework(x, y, velY, fuse, color, false));
        }
        Iterator<Firework> it = this.fireworks.iterator();
        while (it.hasNext()) {
            Firework f = it.next();
            if (!f.exploded) {
                f.y += f.velY;
                f.life -= 1.0f;
                int trailColor = -1426063536;
                graphics.method_25294((int)f.x, (int)f.y, (int)f.x + 2, (int)f.y + 6, trailColor);
                if (!(f.life <= 0.0f)) continue;
                f.exploded = true;
                f.particles = new ArrayList<Particle>();
                int particleCount = 60 + random.nextInt(40);
                for (int i = 0; i < particleCount; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)particleCount;
                    float speed = 1.5f + random.nextFloat() * 2.0f;
                    float vx = (float)(Math.cos(angle) * (double)speed);
                    float vy = (float)(Math.sin(angle) * (double)speed);
                    f.particles.add(new Particle(f.x, f.y, vx, vy, 50 + random.nextInt(30), f.color));
                }
                continue;
            }
            Iterator<Particle> pit = f.particles.iterator();
            while (pit.hasNext()) {
                Particle p = pit.next();
                p.x += p.vx;
                p.y += p.vy;
                p.vy += 0.05f;
                p.life -= 1.0f;
                float alpha = p.life / p.maxLife;
                int alphaColor = (int)(alpha * 255.0f) << 24 | p.color & 0xFFFFFF;
                graphics.method_25294((int)p.x, (int)p.y, (int)p.x + 2, (int)p.y + 2, alphaColor);
                if (!(p.life <= 0.0f)) continue;
                pit.remove();
            }
            if (!f.particles.isEmpty()) continue;
            it.remove();
        }
    }

    protected void method_25426() {
        LocalDate now = LocalDate.now();
        if (now.getMonthValue() == 10 && now.getDayOfMonth() >= 20 && now.getDayOfMonth() <= 23) {
            this.diwaliActive = true;
        }
        RenderSystem.setShaderColor((float)1.6f, (float)1.6f, (float)1.6f, (float)1.0f);
        this.screenOpenTime = System.currentTimeMillis();
        this.errorMessage = null;
        boolean hasReplayMod = FabricLoader.getInstance().isModLoaded("replaymod");
        SidebarWidget sidebar = new SidebarWidget(100);
        sidebar.addServer(class_2960.method_60655((String)"feather_remake", (String)"textures/servers/home_hero_fg_image_dark.png"), "universalmc", "Universalmc.fun", true);
        sidebar.addServer(class_2960.method_60655((String)"feather_remake", (String)"textures/servers/fake.png"), "fakepixel", "mc.fakepixel.fun", true);
        sidebar.addServer(class_2960.method_60655((String)"feather_remake", (String)"textures/servers/fire.png"), "firemc", "play.firemc.fun", true);
        sidebar.addServer(class_2960.method_60655((String)"feather_remake", (String)"textures/servers/2b2t.png"), "2b2t", "2b2t.org", true);
        sidebar.addServer(class_2960.method_60655((String)"feather_remake", (String)"textures/servers/paradise.png"), "paradise", "Pvpparadise.net", true);
        sidebar.addServer(class_2960.method_60655((String)"feather_remake", (String)"textures/servers/pvplegacy.png"), "pvplegacy", "play.pvplegacy.net", true);
        this.method_37063((class_364)sidebar);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2 + 20;
        int btnWidth = 128;
        int btnHeight = 25;
        int spacing = 28;
        int squareSize = 23;
        int spacingRight = 5;
        int gapBetween = 5;
        int rightX = this.field_22789 - squareSize - spacingRight;
        this.method_37063((class_364)new TexturedButton(rightX, spacingRight, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new class_429((class_437)this, class_310.method_1551().field_1690)), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/settings.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/settings1.png")));
        this.method_37063((class_364)new TexturedButton(rightX - (squareSize + gapBetween), spacingRight, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new FeatherRemakeScreen()), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mod.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mod1.png")));
        this.method_37063((class_364)new TexturedButton(rightX - (squareSize + gapBetween) * 2, spacingRight, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new class_4325((class_437)this)), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/realm.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/realm1.png")));
        this.method_37063((class_364)new TexturedButton(rightX - (squareSize + gapBetween) * 3, spacingRight, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new ModsScreen((class_437)this)), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/modmenu.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/modmenu1.png")));
        this.method_37063((class_364)new TexturedButton(rightX - (squareSize + gapBetween) * 4, spacingRight, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> {
            if (hasReplayMod) {
                class_310.method_1551().method_1507(new GuiReplayViewer(ReplayModReplay.instance).toMinecraft());
            } else {
                this.errorMessage = class_2561.method_43470((String)"Replay Mod is not installed!");
                this.errorDisplayStartTime = System.currentTimeMillis();
            }
        }, class_2960.method_60655((String)"feather_remake", (String)"textures/gui/replay.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/replay1.png")));
        this.method_37063((class_364)new TexturedButton(rightX - (squareSize + gapBetween) * 5, spacingRight, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new ModrinthDownloaderScreen()), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/resourcepack.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/resourcepack1.png")));
        this.method_37063((class_364)new TexturedButton(rightX - (squareSize + gapBetween) * 6, spacingRight, squareSize, squareSize, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new ScreenPreviewScreen()), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/lane.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/lane1.png")));
        int imageWidth = 130;
        int imageHeight = 80;
        int x = this.field_22789 - imageWidth - 10;
        int y = this.field_22790 - imageHeight - 14;
        this.method_37063((class_364)new serverbtn(x, y, imageWidth, imageHeight, 0, 0, (class_2561)class_2561.method_43470((String)""), btn -> class_310.method_1551().method_1507((class_437)new CapeSelectionScreen()), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/update.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/gui/update.png")));
        this.method_37063((class_364)new TexturedButton(centerX - btnWidth / 2, centerY - spacing * 3, btnWidth, btnHeight, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new class_526((class_437)this)), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/singleplayer.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/singleplayer1.png")));
        this.method_37063((class_364)new TexturedButton(centerX - btnWidth / 2, centerY - spacing * 2, btnWidth, btnHeight, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new class_500((class_437)this)), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/multiplayer.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/multiplayer1.png")));
        this.method_37063((class_364)new TexturedButton(centerX - btnWidth / 2, centerY - spacing, btnWidth, btnHeight, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new ErrorScreen(this, "COSMETICS ONLY WORK INSIDE WORLD! PLEASE TRY AGAIN ")), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/cosmetics.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/cosmetics1.png")));
        this.method_37063((class_364)new TexturedButton(centerX - btnWidth / 2, centerY, btnWidth, btnHeight, 0, 0, (class_2561)class_2561.method_43473(), btn -> class_310.method_1551().method_1507((class_437)new ServerSelectScreen()), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/partners.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/partners1.png")));
        int storeY = centerY + spacing;
        DynamicHueButton storeButton = new DynamicHueButton(centerX - btnWidth / 2, storeY, btnWidth, btnHeight, 0, 0, (class_2561)class_2561.method_43470((String)""), btn -> class_156.method_668().method_670("https://modrinth.com/mod/feather-remake"), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/store.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/store2.png"), TintSettingsScreen.getHue(), 0.1f);
        this.method_37063((class_364)storeButton);
        TintSettingsScreen.registerButton(storeButton);
        int quitY = storeY + btnHeight + 30;
        DynamicHueButton quitButton = new DynamicHueButton(centerX - 41, quitY, 83, 28, 0, 0, (class_2561)class_2561.method_43470((String)"Quit Game"), btn -> class_310.method_1551().method_1592(), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/q1.png"), class_2960.method_60655((String)"feather_remake", (String)"textures/all_buttons/q.png"), TintSettingsScreen.getHue(), 0.1f);
        this.method_37063((class_364)quitButton);
        TintConfig.save();
        TintSettingsScreen.registerButton(quitButton);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderColor((float)1.6f, (float)1.6f, (float)1.6f, (float)1.0f);
        long timeSinceOpen = System.currentTimeMillis() - this.screenOpenTime;
        float alpha = Math.min(1.0f, (float)timeSinceOpen / 750.0f);
        float scale = 0.95f + 0.05f * alpha;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904((double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0, 0.0);
        graphics.method_51448().method_22905(scale, scale, 1.0f);
        graphics.method_51448().method_22904((double)(-this.field_22789) / 2.0, (double)(-this.field_22790) / 2.0, 0.0);
        super.method_25394(graphics, mouseX, mouseY, delta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        class_2960 logo = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/white.png");
        graphics.method_25290(class_1921::method_62275, logo, (this.field_22789 - 140) / 2, this.field_22790 / 2 - 120, 0.0f, 0.0f, 140, 47, 140, 47);
        int boxWidth = 100;
        int boxHeight = 24;
        int squareButtonsTotalWidth = 199;
        int profileX = this.field_22789 - 5 - squareButtonsTotalWidth - 4 - boxWidth;
        int profileY = 5;
        class_2960 profileBg = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/me.png");
        graphics.method_25290(class_1921::method_62275, profileBg, profileX, profileY, 0.0f, 0.0f, boxWidth, boxHeight, boxWidth, boxHeight);
        String playerName = class_310.method_1551().method_1548().method_1676();
        GameProfile profile = new GameProfile(class_310.method_1551().method_1548().method_44717(), playerName);
        class_8685 playerSkin = class_310.method_1551().method_1582().method_52862(profile);
        class_2960 skin = playerSkin.comp_1626();
        int headSrcX = 8;
        int headSrcY = 8;
        int headSize = 16;
        int zoomSize = 8;
        graphics.method_25302(class_1921::method_62275, skin, profileX + 4, profileY + 4, (float)headSrcX, (float)headSrcY, headSize, headSize, zoomSize, zoomSize, 64, 64);
        int textColor = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
        graphics.method_25303(class_310.method_1551().field_1772, playerName, profileX + 24, profileY + 8, textColor);
        class_2960 versionLabel = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/version.png");
        int versionWidth = 90;
        int versionHeight = 8;
        int versionX = (this.field_22789 - versionWidth) / 2;
        int versionY = this.field_22790 - versionHeight - 8;
        graphics.method_25290(class_1921::method_62275, versionLabel, versionX, versionY, 0.0f, 0.0f, versionWidth, versionHeight, versionWidth, versionHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_51448().method_22909();
        this.renderFireworks(graphics, delta);
        if (this.errorMessage != null) {
            long timeSinceError = System.currentTimeMillis() - this.errorDisplayStartTime;
            if (timeSinceError < 3000L) {
                float errorAlpha = Math.min(1.0f, (float)(3000L - timeSinceError) / 1000.0f);
                int color = (int)(errorAlpha * 255.0f) << 24 | 0xFF5555;
                graphics.method_27534(class_310.method_1551().field_1772, this.errorMessage, this.field_22789 / 2, this.field_22790 / 4, color);
            } else {
                this.errorMessage = null;
            }
        }
    }

    public boolean method_25422() {
        return false;
    }

    private static class Firework {
        float x;
        float y;
        float velY;
        float life;
        float maxLife;
        int color;
        boolean exploded;
        List<Particle> particles;

        Firework(float x, float y, float velY, float life, int color, boolean exploded) {
            this.x = x;
            this.y = y;
            this.velY = velY;
            this.life = life;
            this.maxLife = life;
            this.color = color;
            this.exploded = exploded;
        }
    }

    private static class Particle {
        float x;
        float y;
        float vx;
        float vy;
        float life;
        float maxLife;
        int color;

        Particle(float x, float y, float vx, float vy, float life, int color) {
            this.x = x;
            this.y = y;
            this.vx = vx;
            this.vy = vy;
            this.life = life;
            this.maxLife = life;
            this.color = color;
        }
    }
}

