/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.hudmanage;

import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class HudEditorOverlay {
    private static final class_2960 HANDLE_DISABLE = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/handles/remove.png");
    private static final class_2960 HANDLE_CONFIG = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/handles/settings.png");
    private static final class_2960 HANDLE_RESIZE = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/handles/cursor.png");
    private static final int HANDLE_SIZE = 12;

    private static void drawHandle(class_332 graphics, class_2960 texture, int hx, int hy, int size, double mouseX, double mouseY) {
        boolean hovered = mouseX >= (double)hx && mouseX <= (double)(hx + size) && mouseY >= (double)hy && mouseY <= (double)(hy + size);
        int bgColor = hovered ? 0x6600FFFF : 0x66000000;
        graphics.method_25294(hx, hy, hx + size, hy + size, bgColor);
        graphics.method_25290(class_1921::method_62275, texture, hx, hy, 0.0f, 0.0f, size, size, size, size);
    }

    public static void renderEditing(class_332 graphics, class_327 font, int x, int y, int width, int height, double mouseX, double mouseY, String label) {
        boolean hovered = mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
        int bgColor = hovered ? 0x6600FFFF : 0x66000000;
        graphics.method_25294(x, y, x + width, y + height, bgColor);
        int outlineColor = hovered ? -16711681 : -7829368;
        graphics.method_49601(x, y, width, height, outlineColor);
        int labelWidth = font.method_1727(label);
        graphics.method_25294(x + (width - labelWidth) / 2 - 3, y - 12, x + (width + labelWidth) / 2 + 3, y - 2, -2013265920);
        graphics.method_51433(font, label, x + width / 2 - labelWidth / 2, y - 10, -1, false);
    }

    public static boolean handleClick(double mouseX, double mouseY, int button, int x, int y, int width, int height, HudEditorCallbacks callbacks) {
        if (button != 0) {
            return false;
        }
        int size = 12;
        if (HudEditorOverlay.inBox(mouseX, mouseY, x - size, y - size, size)) {
            callbacks.onDisable();
            return true;
        }
        if (HudEditorOverlay.inBox(mouseX, mouseY, x + width, y - size, size)) {
            callbacks.onOpenConfig();
            return true;
        }
        if (HudEditorOverlay.inBox(mouseX, mouseY, x + width, y + height, size)) {
            callbacks.onResizeStart();
            return true;
        }
        return false;
    }

    private static boolean inBox(double mouseX, double mouseY, int hx, int hy, int size) {
        return mouseX >= (double)hx && mouseX <= (double)(hx + size) && mouseY >= (double)hy && mouseY <= (double)(hy + size);
    }

    public static interface HudEditorCallbacks {
        public void onDisable();

        public void onOpenConfig();

        public void onResizeStart();
    }
}

