/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.input;

import java.lang.reflect.Field;
import net.minecraft.class_310;
import org.ashmeetop.feather_remake.client.settings.ZoomSettings;
import org.ashmeetop.feather_remake.client.util.ZoomMod;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWScrollCallback;

public class ZoomScrollHandler {
    public static float currentZoom = 1.0f;
    private static GLFWScrollCallback oldScrollCallback;

    public static void init() {
        long window = GLFW.glfwGetCurrentContext();
        oldScrollCallback = GLFW.glfwSetScrollCallback((long)window, (w, xOffset, yOffset) -> {
            if (!ZoomMod.isZooming() && oldScrollCallback != null) {
                oldScrollCallback.invoke(w, xOffset, yOffset);
            }
            if (ZoomMod.isZooming()) {
                float zoomStep = 0.8f;
                ZoomSettings.targetZoom += yOffset > 0.0 ? zoomStep : -zoomStep;
                ZoomSettings.targetZoom = Math.max(1.0f, Math.min(10.0f, ZoomSettings.targetZoom));
            }
        });
    }

    public static void tick() {
        class_310 mc = class_310.method_1551();
        if (ZoomMod.isZooming()) {
            float lerpSpeed = ZoomSettings.zoomSpeed;
            ZoomSettings.currentZoom += (ZoomSettings.targetZoom - ZoomSettings.currentZoom) * lerpSpeed;
        } else {
            ZoomSettings.currentZoom += (1.0f - ZoomSettings.currentZoom) * ZoomSettings.zoomSpeed;
        }
        try {
            Field fovField = mc.field_1690.getClass().getDeclaredField("fov");
            fovField.setAccessible(true);
            float sensitivityFactor = 1.0f / ZoomSettings.currentZoom;
            fovField.setFloat(mc.field_1690, 70.0f * sensitivityFactor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

