/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_757;
import org.ashmeetop.feather_remake.client.settings.ZoomSettings;
import org.ashmeetop.feather_remake.client.util.ZoomMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_757.class})
public class ZoomMixin {
    @Shadow
    private class_310 field_4015;
    private float zoomProgress = 0.0f;
    private float lastZoomProgress = 0.0f;

    @ModifyReturnValue(method={"getFov(Lnet/minecraft/client/Camera;FZ)F"}, at={@At(value="RETURN")})
    private float applyZoomToFov(float original, class_4184 camera, float partialTicks, boolean useFovSetting) {
        if (!ZoomSettings.enabled || this.field_4015.field_1724 == null) {
            return original;
        }
        boolean isZooming = ZoomMod.isZooming();
        this.lastZoomProgress = this.zoomProgress;
        float target = isZooming ? 1.0f : 0.0f;
        float lerpSpeed = ZoomSettings.zoomSpeed * 0.1f;
        this.zoomProgress += (target - this.zoomProgress) * lerpSpeed;
        this.zoomProgress = Math.max(0.0f, Math.min(1.0f, this.zoomProgress));
        if (this.zoomProgress <= 0.001f) {
            return original;
        }
        float zoomedFov = original / ZoomSettings.targetZoom;
        return original + (zoomedFov - original) * this.zoomProgress;
    }
}

