/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ZoomSettings {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "config/feather_remake/zoom_settings.json");
    public static boolean enabled = true;
    public static boolean smoothCamera = false;
    public static float targetZoom = 5.0f;
    public static float zoomSpeed = 0.5f;
    public static float zoomStep = 0.1f;
    public static float zoomSensitivity = 5.0f;
    public static float currentZoom = targetZoom;

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)new Data(enabled, smoothCamera, targetZoom, zoomSpeed, zoomStep, zoomSensitivity), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            ZoomSettings.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            Data data = (Data)GSON.fromJson((Reader)reader, Data.class);
            enabled = data.enabled;
            smoothCamera = data.smoothCamera;
            targetZoom = data.targetZoom;
            zoomSpeed = data.zoomSpeed;
            zoomStep = data.zoomStep;
            zoomSensitivity = data.zoomSensitivity;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private record Data(boolean enabled, boolean smoothCamera, float targetZoom, float zoomSpeed, float zoomStep, float zoomSensitivity) {
    }
}

