/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.ashmeetop.feather_remake.client.hudmanage.HudEditorOverlay;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class ArmorHud
implements HudElement {
    private int x = 10;
    private int y = 10;
    private int width = 70;
    private int height = 80;
    private boolean resizing = false;
    private boolean enabled = true;
    private int color = -1;
    private boolean background = true;
    private boolean rgbMode = false;

    @Override
    public void render(class_332 graphics, float partialTicks, double mouseX, double mouseY) {
        this.render(graphics, false, mouseX, mouseY);
    }

    @Override
    public void render(class_332 graphics, boolean editing, double mouseX, double mouseY) {
        if (!this.enabled && !editing) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null || client.field_1690.field_1842) {
            return;
        }
        class_327 font = client.field_1772;
        List<class_1799> armor = List.of(player.method_31548().method_5438(39), player.method_31548().method_5438(38), player.method_31548().method_5438(37), player.method_31548().method_5438(36));
        boolean anyArmor = armor.stream().anyMatch(stack -> !stack.method_7960());
        if (!anyArmor && !editing) {
            return;
        }
        if (this.background) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -2013265920);
        }
        int iconSize = 20;
        float spacing = 0.5f;
        int drawY = this.y;
        for (class_1799 stack2 : armor) {
            if (stack2.method_7960() && !editing) continue;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            graphics.method_51427(stack2, this.x, drawY);
            graphics.method_51431(font, stack2, this.x, drawY);
            int max = stack2.method_7936();
            int current = max - stack2.method_7919();
            String durability = current + "/" + max;
            float percent = (float)current / (float)max;
            int durabilityColor = percent > 0.5f ? -16711936 : (percent > 0.25f ? -256 : -65536);
            graphics.method_51433(font, durability, this.x + iconSize + 4, drawY + 6, durabilityColor, false);
            graphics.method_51448().method_22909();
            drawY = (int)((float)drawY + ((float)iconSize + spacing));
        }
        if (editing) {
            HudEditorOverlay.renderEditing(graphics, font, this.x, this.y, this.width, this.height, mouseX, mouseY, "[ ARMOR HUD ]");
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return HudEditorOverlay.handleClick(mouseX, mouseY, button, this.x, this.y, this.width, this.height, new HudEditorOverlay.HudEditorCallbacks(){

            @Override
            public void onDisable() {
                ArmorHud.this.setEnabled(false);
            }

            @Override
            public void onOpenConfig() {
                class_437 parent = class_310.method_1551().field_1755;
                class_310.method_1551().method_1507(ArmorHud.this.getConfigScreen(parent));
            }

            @Override
            public void onResizeStart() {
                ArmorHud.this.setResizing(true);
            }
        });
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        int size = 12;
        return mouseX >= (double)(this.x + this.width) && mouseX <= (double)(this.x + this.width + size) && mouseY >= (double)(this.y + this.height) && mouseY <= (double)(this.y + this.height + size);
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setResizing(boolean resizing) {
        this.resizing = resizing;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }

    @Override
    public String getName() {
        return "Armor";
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/arm.png");
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public int getIconWidth() {
        return 48;
    }

    @Override
    public int getIconHeight() {
        return 24;
    }
}

