/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import java.awt.Color;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.ashmeetop.feather_remake.client.hudmanage.HudEditorOverlay;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class CompassHud
implements HudElement {
    private int x = 70;
    private int y = 60;
    private int width = 200;
    private int height = 24;
    private boolean enabled = true;
    private int color = -1;
    private boolean background = true;
    private boolean rgbMode = false;
    private boolean resizing = false;
    private static final class_310 mc = class_310.method_1551();
    private static final String[] DIRECTIONS = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};

    @Override
    public void render(class_332 graphics, float partialTicks, double mouseX, double mouseY) {
        this.render(graphics, false, 0.0, 0.0);
    }

    @Override
    public void render(class_332 graphics, boolean editing, double mouseX, double mouseY) {
        if (!this.enabled || CompassHud.mc.field_1724 == null) {
            return;
        }
        int drawColor = this.color;
        if (this.rgbMode) {
            float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
            drawColor = Color.HSBtoRGB(hue, 1.0f, 1.0f) | 0xFF000000;
        }
        class_746 player = CompassHud.mc.field_1724;
        if (this.background) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -2013265920);
        }
        float yawPrev = this.normalize(player.field_5982);
        float yawNow = this.normalize(player.method_36454());
        float yaw = this.lerpAngle(0.0f, yawPrev, yawNow);
        float compassYaw = (yaw - 180.0f + 360.0f) % 360.0f;
        int centerX = this.x + this.width / 2;
        int tickSpacing = 4;
        int visibleDegrees = this.width / tickSpacing;
        for (int i = -visibleDegrees / 2; i <= visibleDegrees / 2; ++i) {
            float degree = (compassYaw + (float)i + 360.0f) % 360.0f;
            int screenX = centerX + i * tickSpacing;
            if (screenX < this.x || screenX > this.x + this.width) continue;
            int rounded = Math.round(degree);
            if (rounded % 45 == 0) {
                String dir = DIRECTIONS[rounded / 45 % DIRECTIONS.length];
                int textWidth = CompassHud.mc.field_1772.method_1727(dir);
                graphics.method_51433(CompassHud.mc.field_1772, dir, screenX - textWidth / 2, this.y + 2, drawColor, false);
                graphics.method_25294(screenX, this.y + this.height - 6, screenX + 1, this.y + this.height - 2, drawColor);
                continue;
            }
            if (rounded % 15 == 0) {
                graphics.method_25294(screenX, this.y + this.height - 5, screenX + 1, this.y + this.height - 2, -5592406);
                continue;
            }
            if (rounded % 5 != 0) continue;
            graphics.method_25294(screenX, this.y + this.height - 4, screenX + 1, this.y + this.height - 2, -8947849);
        }
        graphics.method_25294(centerX - 1, this.y, centerX + 1, this.y + this.height, -65536);
        if (editing) {
            HudEditorOverlay.renderEditing(graphics, CompassHud.mc.field_1772, this.x, this.y, this.width, this.height, mouseX, mouseY, "[ COMPASS HUD ]");
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return HudEditorOverlay.handleClick(mouseX, mouseY, button, this.x, this.y, this.width, this.height, new HudEditorOverlay.HudEditorCallbacks(){

            @Override
            public void onDisable() {
                CompassHud.this.setEnabled(false);
            }

            @Override
            public void onOpenConfig() {
                mc.method_1507(CompassHud.this.getConfigScreen(CompassHud.mc.field_1755));
            }

            @Override
            public void onResizeStart() {
                CompassHud.this.setResizing(true);
            }
        });
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setResizing(boolean resizing) {
        this.resizing = resizing;
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        int size = 12;
        return mouseX >= (double)(this.x + this.width) && mouseX <= (double)(this.x + this.width + size) && mouseY >= (double)(this.y + this.height) && mouseY <= (double)(this.y + this.height + size);
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }

    @Override
    public String getName() {
        return "Compass";
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/compass.png");
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public int getIconWidth() {
        return 24;
    }

    @Override
    public int getIconHeight() {
        return 24;
    }

    private float normalize(float angle) {
        return (angle % 360.0f + 360.0f) % 360.0f;
    }

    private float lerpAngle(float t, float a, float b) {
        float diff = (b - a + 540.0f) % 360.0f - 180.0f;
        return (a + diff * t + 360.0f) % 360.0f;
    }
}

