/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import java.awt.Color;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.ashmeetop.feather_remake.client.hudmanage.HudEditorOverlay;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class CoordinatesHud
implements HudElement {
    private int x = 70;
    private int y = 35;
    private int width = 120;
    private int height = 20;
    private boolean enabled = true;
    private int color = -1;
    private boolean background = true;
    private boolean rgbMode = false;
    private boolean resizing = false;
    private static final class_310 mc = class_310.method_1551();

    @Override
    public void render(class_332 graphics, float partialTicks, double mouseX, double mouseY) {
        this.render(graphics, false, mouseX, mouseY);
    }

    @Override
    public void render(class_332 graphics, boolean editing, double mouseX, double mouseY) {
        if (!this.enabled || CoordinatesHud.mc.field_1724 == null) {
            return;
        }
        class_746 player = CoordinatesHud.mc.field_1724;
        int drawColor = this.color;
        if (this.rgbMode) {
            float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
            drawColor = Color.HSBtoRGB(hue, 1.0f, 1.0f) | 0xFF000000;
        }
        if (this.background) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -2013265920);
        }
        String xCoord = String.format("%.2f", player.method_23317());
        String yCoord = String.format("%.2f", player.method_23318());
        String zCoord = String.format("%.2f", player.method_23321());
        String text = String.format("XYZ: %s, %s, %s", xCoord, yCoord, zCoord);
        graphics.method_51433(CoordinatesHud.mc.field_1772, text, this.x + 2, this.y + 2, drawColor, false);
        if (editing) {
            HudEditorOverlay.renderEditing(graphics, CoordinatesHud.mc.field_1772, this.x, this.y, this.width, this.height, mouseX, mouseY, "[ COORDINATES HUD ]");
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return HudEditorOverlay.handleClick(mouseX, mouseY, button, this.x, this.y, this.width, this.height, new HudEditorOverlay.HudEditorCallbacks(){

            @Override
            public void onDisable() {
                CoordinatesHud.this.setEnabled(false);
            }

            @Override
            public void onOpenConfig() {
                mc.method_1507(CoordinatesHud.this.getConfigScreen(CoordinatesHud.mc.field_1755));
            }

            @Override
            public void onResizeStart() {
                CoordinatesHud.this.resizing = true;
            }
        });
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        int handleSize = 12;
        return mouseX >= (double)(this.x + this.width) && mouseX <= (double)(this.x + this.width + handleSize) && mouseY >= (double)(this.y + this.height) && mouseY <= (double)(this.y + this.height + handleSize);
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }

    @Override
    public String getName() {
        return "Coordinates";
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/cords.png");
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public int getIconWidth() {
        return 24;
    }

    @Override
    public int getIconHeight() {
        return 24;
    }
}

