/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import java.awt.Color;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.ashmeetop.feather_remake.client.hudmanage.HudEditorOverlay;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class CpsHud
implements HudElement {
    private static final class_310 mc = class_310.method_1551();
    private static final Queue<Long> leftClickTimes = new LinkedList<Long>();
    private static final Queue<Long> rightClickTimes = new LinkedList<Long>();
    private static boolean leftWasDown = false;
    private static boolean rightWasDown = false;
    private static int displayedLeftCPS = 0;
    private static int displayedRightCPS = 0;
    private static long lastUpdateTime = System.currentTimeMillis();
    private int x = 10;
    private int y = 10;
    private int width = 70;
    private int height = 14;
    private boolean enabled = true;
    private int color = -1;
    private boolean background = true;
    private boolean rgbMode = false;
    private boolean resizing = false;

    @Override
    public void render(class_332 graphics, float partialTicks, double mouseX, double mouseY) {
        this.render(graphics, false, mouseX, mouseY);
    }

    @Override
    public void render(class_332 graphics, boolean editing, double mouseX, double mouseY) {
        if (!this.enabled || CpsHud.mc.field_1724 == null) {
            return;
        }
        int drawColor = this.color;
        if (this.rgbMode) {
            float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
            drawColor = Color.HSBtoRGB(hue, 1.0f, 1.0f) | 0xFF000000;
        }
        String text = "CPS: " + displayedLeftCPS + " | " + displayedRightCPS;
        if (this.background) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -2013265920);
        }
        graphics.method_51433(CpsHud.mc.field_1772, text, this.x + 2, this.y + 2, drawColor, false);
        if (editing) {
            HudEditorOverlay.renderEditing(graphics, CpsHud.mc.field_1772, this.x, this.y, this.width, this.height, mouseX, mouseY, "[ CPS HUD ]");
        }
    }

    @Override
    public void tick() {
        long currentTime = System.currentTimeMillis();
        boolean leftDown = CpsHud.mc.field_1690.field_1886.method_1434();
        boolean rightDown = CpsHud.mc.field_1690.field_1904.method_1434();
        if (leftDown && !leftWasDown) {
            leftClickTimes.add(currentTime);
        }
        leftWasDown = leftDown;
        if (rightDown && !rightWasDown) {
            rightClickTimes.add(currentTime);
        }
        rightWasDown = rightDown;
        while (!leftClickTimes.isEmpty() && currentTime - leftClickTimes.peek() > 1000L) {
            leftClickTimes.poll();
        }
        while (!rightClickTimes.isEmpty() && currentTime - rightClickTimes.peek() > 1000L) {
            rightClickTimes.poll();
        }
        if (currentTime - lastUpdateTime >= 50L) {
            displayedLeftCPS = leftClickTimes.size();
            displayedRightCPS = rightClickTimes.size();
            lastUpdateTime = currentTime;
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return HudEditorOverlay.handleClick(mouseX, mouseY, button, this.x, this.y, this.width, this.height, new HudEditorOverlay.HudEditorCallbacks(){

            @Override
            public void onDisable() {
                CpsHud.this.setEnabled(false);
            }

            @Override
            public void onOpenConfig() {
                mc.method_1507(CpsHud.this.getConfigScreen(CpsHud.mc.field_1755));
            }

            @Override
            public void onResizeStart() {
                CpsHud.this.resizing = true;
            }
        });
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        int handleSize = 12;
        return mouseX >= (double)(this.x + this.width) && mouseX <= (double)(this.x + this.width + handleSize) && mouseY >= (double)(this.y + this.height) && mouseY <= (double)(this.y + this.height + handleSize);
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }

    @Override
    public String getName() {
        return "CPS";
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/cps.png");
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public int getIconWidth() {
        return 24;
    }

    @Override
    public int getIconHeight() {
        return 24;
    }
}

