/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import java.awt.Color;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_898;
import org.ashmeetop.feather_remake.client.hudmanage.HudEditorOverlay;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class JadeHud
implements HudElement {
    private static final class_310 mc = class_310.method_1551();
    private int x = 70;
    private int y = 10;
    private int width = 140;
    private int height = 50;
    private boolean enabled = true;
    private boolean background = true;
    private int color = -1;
    private boolean rgbMode = false;
    private boolean resizing = false;

    @Override
    public void render(class_332 graphics, float partialTicks, double mouseX, double mouseY) {
        this.render(graphics, false, mouseX, mouseY);
    }

    @Override
    public void render(class_332 graphics, boolean editing, double mouseX, double mouseY) {
        class_3966 entityHit;
        class_1297 block;
        if (!this.enabled) {
            return;
        }
        int drawColor = this.rgbMode ? this.getRgbColor() : this.color;
        class_239 hit = JadeHud.mc.field_1765;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.x, (float)this.y, 0.0f);
        if (this.background) {
            graphics.method_25294(0, 0, this.width, this.height, -2013265920);
        }
        if (hit instanceof class_3965) {
            class_3965 blockHit = (class_3965)hit;
            class_2680 state = JadeHud.mc.field_1687.method_8320(blockHit.method_17777());
            block = state.method_26204();
            String blockName = block.method_9518().getString();
            graphics.method_51427(new class_1799((class_1935)block), 5, 5);
            graphics.method_51433(JadeHud.mc.field_1772, blockName, 25, 8, drawColor, false);
            float destroySpeed = JadeHud.mc.field_1724 != null ? JadeHud.mc.field_1724.method_7351(state) : 0.0f;
            float maxSpeed = 10.0f;
            float progress = Math.min(destroySpeed / maxSpeed, 1.0f);
            int barWidth = this.width - 10;
            int filledWidth = (int)(progress * (float)barWidth);
            graphics.method_25294(5, this.height - 12, 5 + barWidth, this.height - 8, -11184811);
            graphics.method_25294(5, this.height - 12, 5 + filledWidth, this.height - 8, -16711936);
        }
        if (hit instanceof class_3966 && (block = (entityHit = (class_3966)hit).method_17782()) instanceof class_1309) {
            class_1309 living = (class_1309)block;
            this.renderEntity(graphics, living, 20, 20, 20);
            String entityName = living.method_5477().getString();
            graphics.method_51433(JadeHud.mc.field_1772, entityName, 45, 8, drawColor, false);
            float healthPercent = living.method_6032() / living.method_6063();
            int barWidth = this.width - 10;
            int filledWidth = (int)(healthPercent * (float)barWidth);
            graphics.method_25294(5, this.height - 6, 5 + barWidth, this.height - 2, -11184811);
            graphics.method_25294(5, this.height - 6, 5 + filledWidth, this.height - 2, -65536);
        }
        graphics.method_51448().method_22909();
        if (editing) {
            HudEditorOverlay.renderEditing(graphics, JadeHud.mc.field_1772, this.x, this.y, this.width, this.height, mouseX, mouseY, "[ JADE HUD ]");
        }
    }

    private void renderEntity(class_332 graphics, class_1309 entity, int x, int y, int scale) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 50.0f);
        graphics.method_51448().method_22905((float)scale / entity.method_55693(), (float)scale / entity.method_55693(), (float)(-scale) / entity.method_55693());
        graphics.method_51448().method_22907((Quaternionfc)new Quaternionf().rotateZ((float)Math.PI).rotateX(-0.5235988f));
        class_898 dispatcher = mc.method_1561();
        dispatcher.method_3948(false);
        graphics.method_64039(multiBufferSource -> dispatcher.method_62424((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, graphics.method_51448(), multiBufferSource, 0xF000F0));
        dispatcher.method_3948(true);
        graphics.method_51448().method_22909();
    }

    private int getRgbColor() {
        float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
        return Color.HSBtoRGB(hue, 1.0f, 1.0f) | 0xFF000000;
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return HudEditorOverlay.handleClick(mouseX, mouseY, button, this.x, this.y, this.width, this.height, new HudEditorOverlay.HudEditorCallbacks(){

            @Override
            public void onDisable() {
                JadeHud.this.setEnabled(false);
            }

            @Override
            public void onOpenConfig() {
                mc.method_1507(JadeHud.this.getConfigScreen(JadeHud.mc.field_1755));
            }

            @Override
            public void onResizeStart() {
                JadeHud.this.resizing = true;
            }
        });
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        int handleSize = 12;
        return mouseX >= (double)(this.x + this.width) && mouseX <= (double)(this.x + this.width + handleSize) && mouseY >= (double)(this.y + this.height) && mouseY <= (double)(this.y + this.height + handleSize);
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }

    @Override
    public String getName() {
        return "JADE";
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/jade.png");
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public int getIconWidth() {
        return 24;
    }

    @Override
    public int getIconHeight() {
        return 24;
    }
}

