/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.ashmeetop.feather_remake.client.hudmanage.HudEditorOverlay;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class MiniMapHud
implements HudElement {
    private static final class_310 mc = class_310.method_1551();
    private static final class_2960 RESIZE_HANDLE = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/remove.png");
    private int x = 10;
    private int y = 10;
    private int size = 100;
    private boolean enabled = true;
    private boolean background = true;
    private boolean rgbMode = false;
    private int color = -1;
    private boolean showEntities = true;
    private boolean resizing = false;

    @Override
    public void render(class_332 graphics, float tickDelta, double mouseX, double mouseY) {
        this.render(graphics, false, mouseX, mouseY);
    }

    @Override
    public void render(class_332 graphics, boolean editing, double mouseX, double mouseY) {
        if (!this.enabled) {
            if (!editing) {
                return;
            }
            HudEditorOverlay.renderEditing(graphics, class_310.method_1551().field_1772, this.x, this.y, this.size, this.size, mouseX, mouseY, "[ MiniMap Disabled ]");
            return;
        }
        if (MiniMapHud.mc.field_1724 == null || MiniMapHud.mc.field_1687 == null) {
            return;
        }
        int cx = this.x + this.size / 2;
        int cy = this.y + this.size / 2;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.x, (float)this.y, 0.0f);
        float scale = (float)this.size / 64.0f;
        graphics.method_51448().method_22905(scale, scale, 1.0f);
        int radius = 32;
        int playerX = (int)MiniMapHud.mc.field_1724.method_23317();
        int playerZ = (int)MiniMapHud.mc.field_1724.method_23321();
        for (int dx = -radius; dx < radius; ++dx) {
            for (int dz = -radius; dz < radius; ++dz) {
                int worldX = playerX + dx;
                int worldZ = playerZ + dz;
                int yTop = MiniMapHud.mc.field_1687.method_8624(class_2902.class_2903.field_13202, worldX, worldZ);
                class_2338 pos = new class_2338(worldX, yTop - 1, worldZ);
                class_2680 state = MiniMapHud.mc.field_1687.method_8320(pos);
                int blockColor = mc.method_1505().method_1697(state, (class_1920)MiniMapHud.mc.field_1687, pos, 0);
                if (blockColor == -1) {
                    blockColor = -11184811;
                }
                int px = radius + dx;
                int pz = radius + dz;
                graphics.method_25294(px, pz, px + 1, pz + 1, blockColor | 0xFF000000);
            }
        }
        if (this.showEntities) {
            double radarRange = 32.0;
            for (class_1297 entity : MiniMapHud.mc.field_1687.method_18112()) {
                double dz;
                double dx;
                if (entity == MiniMapHud.mc.field_1724 || (dx = entity.method_23317() - MiniMapHud.mc.field_1724.method_23317()) * dx + (dz = entity.method_23321() - MiniMapHud.mc.field_1724.method_23321()) * dz > radarRange * radarRange) continue;
                int ex = radius + (int)dx;
                int ez = radius + (int)dz;
                graphics.method_25294(ex - 1, ez - 1, ex + 1, ez + 1, -65536);
            }
        }
        graphics.method_25294(radius - 2, radius - 2, radius + 2, radius + 2, -16711936);
        graphics.method_51448().method_22909();
        if (editing) {
            HudEditorOverlay.renderEditing(graphics, MiniMapHud.mc.field_1772, this.x, this.y, this.size, this.size, mouseX, mouseY, "[ MiniMap ]");
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return HudEditorOverlay.handleClick(mouseX, mouseY, button, this.x, this.y, this.size, this.size, new HudEditorOverlay.HudEditorCallbacks(){

            @Override
            public void onDisable() {
                MiniMapHud.this.setEnabled(false);
            }

            @Override
            public void onOpenConfig() {
                mc.method_1507(MiniMapHud.this.getConfigScreen(MiniMapHud.mc.field_1755));
            }

            @Override
            public void onResizeStart() {
                MiniMapHud.this.resizing = true;
            }
        });
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.size) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.size);
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        int handleSize = 12;
        return mouseX >= (double)(this.x + this.size) && mouseX <= (double)(this.x + this.size + handleSize) && mouseY >= (double)(this.y + this.size) && mouseY <= (double)(this.y + this.size + handleSize);
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.size = Math.min(width, height);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.size;
    }

    @Override
    public int getHeight() {
        return this.size;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }

    @Override
    public String getName() {
        return "MiniMap";
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/minmap.png");
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public int getIconWidth() {
        return 24;
    }

    @Override
    public int getIconHeight() {
        return 24;
    }
}

