/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import java.awt.Color;
import java.util.Collection;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4074;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import org.ashmeetop.feather_remake.client.hudmanage.HudEditorOverlay;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class PotionHud
implements HudElement {
    private static final class_2960 ICON = class_2960.method_60655((String)"feather_remake", (String)"textures/icons/eff.png");
    private static final int EFFECT_HEIGHT = 26;
    private static final int EFFECT_WIDTH = 120;
    private int x = 5;
    private int y = 5;
    private int width = 120;
    private int height = 0;
    private boolean enabled = true;
    private boolean background = true;
    private boolean rgbMode = false;
    private int color = -1;
    private boolean showDuration = true;
    private boolean showAmplifier = true;
    private boolean showEffectName = true;

    @Override
    public void render(class_332 graphics, float tickDelta, double mouseX, double mouseY) {
        this.render(graphics, false, mouseX, mouseY);
    }

    @Override
    public void render(class_332 graphics, boolean editing, double mouseX, double mouseY) {
        if (!this.enabled) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        Collection effects = mc.field_1724.method_6026();
        if (effects.isEmpty()) {
            return;
        }
        this.setSize(this.width, effects.size() * 26);
        if (this.background) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, 0x66000000);
        }
        this.renderEffects(graphics, effects);
        if (editing) {
            HudEditorOverlay.renderEditing(graphics, mc.field_1772, this.x, this.y, this.width, this.height, mouseX, mouseY, "[ POTION HUD ]");
        }
    }

    private void renderEffects(class_332 graphics, Collection<class_1293> effects) {
        class_310 mc = class_310.method_1551();
        class_4074 textureManager = mc.method_18505();
        int index = 0;
        for (class_1293 effect : effects) {
            if (!effect.method_5592()) continue;
            class_6880 holder = effect.method_5579();
            int drawX = this.x + 3;
            int drawY = this.y + index * 26 + 3;
            class_1058 icon = textureManager.method_18663(holder);
            graphics.method_52710(class_1921::method_62275, icon, drawX, drawY, 18, 18, -1);
            int textColor = this.rgbMode ? this.getRgbColor() : this.color;
            int textX = drawX + 24;
            if (this.showEffectName) {
                Object name = ((class_1291)holder.comp_349()).method_5560().getString();
                if (this.showAmplifier && effect.method_5578() > 0) {
                    name = (String)name + " " + PotionHud.toRoman(effect.method_5578() + 1);
                }
                graphics.method_51433(mc.field_1772, (String)name, textX, drawY + 5, textColor, false);
            }
            if (this.showDuration && !effect.method_48559()) {
                class_2561 duration = class_1292.method_5577((class_1293)effect, (float)1.0f, (float)1.0f);
                graphics.method_51439(mc.field_1772, duration, textX, drawY + 15, textColor, false);
            }
            ++index;
        }
    }

    private int getRgbColor() {
        float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
        return Color.HSBtoRGB(hue, 1.0f, 1.0f) | 0xFF000000;
    }

    private static String toRoman(int number) {
        return switch (number) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            default -> String.valueOf(number);
        };
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return HudEditorOverlay.handleClick(mouseX, mouseY, button, this.x, this.y, this.width, this.height, new HudEditorOverlay.HudEditorCallbacks(){

            @Override
            public void onDisable() {
                PotionHud.this.setEnabled(false);
            }

            @Override
            public void onOpenConfig() {
            }

            @Override
            public void onResizeStart() {
            }
        });
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x + this.width - 6) && mouseX <= (double)(this.x + this.width) && mouseY >= (double)(this.y + this.height - 6) && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return "Potion Effects";
    }

    @Override
    public class_2960 getIcon() {
        return ICON;
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }

    public void setShowDuration(boolean showDuration) {
        this.showDuration = showDuration;
    }

    public void setShowAmplifier(boolean showAmplifier) {
        this.showAmplifier = showAmplifier;
    }

    public void setShowEffectName(boolean showEffectName) {
        this.showEffectName = showEffectName;
    }
}

