/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_8646;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class ScoreboardHud
implements HudElement {
    private int x = 5;
    private int y = 5;
    private int width = 160;
    private int height = 150;
    private boolean enabled = true;
    private boolean dragging = false;
    private int dragOffsetX;
    private int dragOffsetY;
    private boolean resizing = false;
    private int resizeStartX;
    private int resizeStartY;
    private int resizeStartWidth;
    private int resizeStartHeight;
    private float scale = 1.0f;
    private int color = -1;

    public void render(class_332 graphics, float tickDelta) {
        this.render(graphics, false);
    }

    public void render(class_332 graphics, boolean editing) {
        if (!this.enabled) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_269 scoreboard = mc.field_1687.method_8428();
        class_266 sidebar = scoreboard.method_1189(class_8646.field_45157);
        if (sidebar == null) {
            return;
        }
        if (this.dragging) {
            this.updateDrag(mc.field_1729.method_1603(), mc.field_1729.method_1604());
        }
        if (this.resizing) {
            this.updateResize(mc.field_1729.method_1603(), mc.field_1729.method_1604());
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.x, (float)this.y, 0.0f);
        graphics.method_51448().method_22905(this.scale, this.scale, 1.0f);
        this.renderCustomScoreboard(graphics, sidebar, scoreboard);
        graphics.method_51448().method_22909();
        if (editing) {
            graphics.method_49601(this.x, this.y, (int)((float)this.width * this.scale), (int)((float)this.height * this.scale), -7829368);
            graphics.method_25294((int)((float)this.x + (float)this.width * this.scale - 8.0f), (int)((float)this.y + (float)this.height * this.scale - 8.0f), (int)((float)this.x + (float)this.width * this.scale), (int)((float)this.y + (float)this.height * this.scale), -65536);
        }
    }

    private void renderCustomScoreboard(class_332 graphics, class_266 objective, class_269 scoreboard) {
        String title = objective.method_1114().getString();
        int titleWidth = class_310.method_1551().field_1772.method_1727(title);
        int titleX = (int)((float)this.width / this.scale - (float)titleWidth) / 2;
        graphics.method_25303(class_310.method_1551().field_1772, title, titleX, 0, 0xFFFFFF);
    }

    @Override
    public void render(class_332 graphics, float partialTicks, double mouseX, double mouseY) {
    }

    @Override
    public void render(class_332 graphics, boolean editing, double mouseX, double mouseY) {
    }

    @Override
    public void tick() {
        if (!this.enabled) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_269 scoreboard = mc.field_1687.method_8428();
        class_266 sidebar = scoreboard.method_1189(class_8646.field_45157);
        if (sidebar == null) {
            return;
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public void startDragging(int mouseX, int mouseY) {
        this.dragging = true;
        this.dragOffsetX = mouseX - this.x;
        this.dragOffsetY = mouseY - this.y;
    }

    public void stopDragging() {
        this.dragging = false;
    }

    public void updateDrag(double mouseX, double mouseY) {
        this.x = (int)(mouseX - (double)this.dragOffsetX);
        this.y = (int)(mouseY - (double)this.dragOffsetY);
    }

    public void startResizing(int mouseX, int mouseY) {
        this.resizing = true;
        this.resizeStartX = mouseX;
        this.resizeStartY = mouseY;
        this.resizeStartWidth = this.width;
        this.resizeStartHeight = this.height;
        this.scale = 1.0f;
    }

    public void stopResizing() {
        this.resizing = false;
    }

    public void updateResize(double mouseX, double mouseY) {
        double deltaX = mouseX - (double)this.resizeStartX;
        double deltaY = mouseY - (double)this.resizeStartY;
        this.width = Math.max(50, this.resizeStartWidth + (int)deltaX);
        this.height = Math.max(50, this.resizeStartHeight + (int)deltaY);
        this.scale = Math.min((float)this.width / 160.0f, (float)this.height / 150.0f);
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return "Scoreboard";
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/scoreboard.png");
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setRgbMode(boolean enabled) {
    }

    @Override
    public boolean isRgbMode() {
        return false;
    }

    @Override
    public void setBackground(boolean background) {
    }

    @Override
    public boolean hasBackground() {
        return false;
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)((float)this.x + (float)this.width * this.scale) && mouseY >= (double)this.y && mouseY <= (double)((float)this.y + (float)this.height * this.scale);
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        return mouseX >= (double)((float)this.x + (float)this.width * this.scale - 8.0f) && mouseX <= (double)((float)this.x + (float)this.width * this.scale) && mouseY >= (double)((float)this.y + (float)this.height * this.scale - 8.0f) && mouseY <= (double)((float)this.y + (float)this.height * this.scale);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public float getScale() {
        return this.scale;
    }
}

