/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import org.ashmeetop.feather_remake.client.hudmanage.HudEditorOverlay;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;

public class TargetHealthHud
implements HudElement {
    private int x = 10;
    private int y = 5;
    private int width = 100;
    private int height = 20;
    private boolean enabled = true;
    private boolean background = true;
    private int color = -1;
    private boolean rgbMode = false;
    private static final class_2960 RESIZE_HANDLE = class_2960.method_60655((String)"feather_remake", (String)"textures/gui/mods/remove.png");

    @Override
    public void render(class_332 graphics, float tickDelta, double mouseX, double mouseY) {
        this.render(graphics, false, mouseX, mouseY);
    }

    @Override
    public void render(class_332 graphics, boolean editing, double mouseX, double mouseY) {
        if (!this.enabled) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_239 result = mc.field_1765;
        if (!(result instanceof class_3966)) {
            return;
        }
        class_3966 entityResult = (class_3966)result;
        class_1297 class_12972 = entityResult.method_17782();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 entity = (class_1309)class_12972;
        float health = entity.method_6032();
        String name = entity.method_5477().getString();
        Objects.requireNonNull(mc.field_1772);
        this.setSize(this.width, 9 * 2 + 6);
        if (this.background) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, -2013265920);
        }
        int drawColor = this.rgbMode ? this.getRgbColor() : this.color;
        graphics.method_51433(mc.field_1772, name, this.x + 3, this.y + 3, drawColor, false);
        class_327 class_3272 = mc.field_1772;
        String string = "\u2764 " + (int)health;
        Objects.requireNonNull(mc.field_1772);
        graphics.method_51433(class_3272, string, this.x + 3, this.y + 9 + 5, drawColor, false);
        if (editing) {
            HudEditorOverlay.renderEditing(graphics, mc.field_1772, this.x, this.y, this.width, this.height, mouseX, mouseY, "[ HEALTH HUD ]");
        }
    }

    private int getRgbColor() {
        float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
        return Color.HSBtoRGB(hue, 1.0f, 1.0f) | 0xFF000000;
    }

    @Override
    public void tick() {
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return "Target Health";
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return HudEditorOverlay.handleClick(mouseX, mouseY, button, this.x, this.y, this.width, this.height, new HudEditorOverlay.HudEditorCallbacks(){

            @Override
            public void onDisable() {
                TargetHealthHud.this.setEnabled(false);
            }

            @Override
            public void onOpenConfig() {
            }

            @Override
            public void onResizeStart() {
            }
        });
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        return false;
    }

    @Override
    public void init() {
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/heal.png");
    }
}

