/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.util;

import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.ashmeetop.feather_remake.client.hudmanage.HudEditorOverlay;
import org.ashmeetop.feather_remake.client.hudmanage.HudElement;
import org.ashmeetop.feather_remake.client.server.TpsManager;

public class TpsHud
implements HudElement {
    private int x = 70;
    private int y = 40;
    private int width = 50;
    private int height = 20;
    private boolean enabled = true;
    private boolean background = true;
    private int color = -1;
    private boolean rgbMode = false;
    private long lastTime = System.currentTimeMillis();
    private int ticks = 0;
    private int estimatedTps = 20;

    @Override
    public void render(class_332 graphics, float tickDelta, double mouseX, double mouseY) {
        this.render(graphics, false, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return HudEditorOverlay.handleClick(mouseX, mouseY, button, this.x, this.y, this.width, this.height, new HudEditorOverlay.HudEditorCallbacks(){

            @Override
            public void onDisable() {
                TpsHud.this.setEnabled(false);
            }

            @Override
            public void onOpenConfig() {
            }

            @Override
            public void onResizeStart() {
            }
        });
    }

    @Override
    public void render(class_332 graphics, boolean editing, double mouseX, double mouseY) {
        if (!this.enabled) {
            return;
        }
        class_310 mc = class_310.method_1551();
        String text = "TPS: " + this.getTps();
        float scale = Math.min((float)this.width / 50.0f, (float)this.height / 20.0f);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.x, (float)this.y, 0.0f);
        graphics.method_51448().method_22905(scale, scale, 1.0f);
        if (this.background) {
            int bgWidth = mc.field_1772.method_1727(text) + 6;
            Objects.requireNonNull(mc.field_1772);
            int bgHeight = 9 + 4;
            graphics.method_25294(0, 0, bgWidth, bgHeight, -2013265920);
        }
        int drawColor = this.rgbMode ? this.getRgbColor() : this.color;
        graphics.method_51433(mc.field_1772, text, 3, 3, drawColor, false);
        graphics.method_51448().method_22909();
        if (editing) {
            HudEditorOverlay.renderEditing(graphics, mc.field_1772, this.x, this.y, this.width, this.height, mouseX, mouseY, "[ TPS HUD ]");
        }
    }

    private int getRgbColor() {
        float hue = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
        return Color.HSBtoRGB(hue, 1.0f, 1.0f) | 0xFF000000;
    }

    private int getTps() {
        try {
            return TpsManager.getTps();
        }
        catch (Throwable ignored) {
            return Math.min(this.estimatedTps, 20);
        }
    }

    @Override
    public void tick() {
        ++this.ticks;
        long now = System.currentTimeMillis();
        if (now - this.lastTime >= 1000L) {
            this.estimatedTps = this.ticks;
            this.ticks = 0;
            this.lastTime = now;
        }
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return "TPS";
    }

    @Override
    public class_2960 getIcon() {
        return class_2960.method_60655((String)"feather_remake", (String)"textures/icons/tps.png");
    }

    @Override
    public class_437 getConfigScreen(class_437 parent) {
        return null;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public boolean isResizing(double mouseX, double mouseY) {
        return Math.abs(mouseX - (double)(this.x + this.width)) < 6.0 && Math.abs(mouseY - (double)(this.y + this.height)) < 6.0;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setBackground(boolean background) {
        this.background = background;
    }

    @Override
    public boolean hasBackground() {
        return this.background;
    }

    @Override
    public void setRgbMode(boolean enabled) {
        this.rgbMode = enabled;
    }

    @Override
    public boolean isRgbMode() {
        return this.rgbMode;
    }
}

