/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.waypoint;

import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class WaypointBeamRenderer {
    private static final int BEAM_HEIGHT = 256;
    private static final class_2960 BEAM_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/entity/beacon_beam.png");

    public static void renderBeam(class_4587 poseStack, class_4597 consumers, class_243 camPos, double x, double y, double z, float r, float g, float b, float alpha, long worldTime, String name) {
        double dx = x - camPos.field_1352;
        double dy = y - camPos.field_1351;
        double dz = z - camPos.field_1350;
        poseStack.method_22903();
        poseStack.method_22904(dx, dy, dz);
        float time = worldTime % 200L + class_310.method_1551().method_47600();
        float vOffset = -time * 0.2f - class_3532.method_22450((float)(-time * 0.1f));
        WaypointBeamRenderer.renderBeamLayer(poseStack, consumers, 0.18f, r, g, b, alpha, vOffset, 1.0f, 0.0f);
        if (name != null && !name.isEmpty()) {
            WaypointBeamRenderer.renderNameTag(poseStack, consumers, camPos, x, y, z, name);
        }
        poseStack.method_22909();
    }

    private static void renderBeamLayer(class_4587 poseStack, class_4597 consumers, float radius, float r, float g, float b, float alpha, float vOffset, float brightness, float rotation) {
        class_4588 buffer = consumers.getBuffer(class_1921.method_23592((class_2960)BEAM_TEXTURE, (boolean)true));
        float v1 = vOffset;
        float v2 = 64.0f + vOffset;
        for (int i = 0; i < 4; ++i) {
            float angle1 = (float)(1.5707963267948966 * (double)i) + rotation;
            float angle2 = (float)(1.5707963267948966 * (double)(i + 1)) + rotation;
            float x1 = class_3532.method_15362((float)angle1) * radius;
            float z1 = class_3532.method_15374((float)angle1) * radius;
            float x2 = class_3532.method_15362((float)angle2) * radius;
            float z2 = class_3532.method_15374((float)angle2) * radius;
            float topAlpha = alpha * 0.2f;
            float bottomAlpha = alpha;
            buffer.method_22918(poseStack.method_23760().method_23761(), x1, 256.0f, z1).method_22915(r * brightness, g * brightness, b * brightness, topAlpha).method_22913(0.0f, v2).method_22914(0.0f, 1.0f, 0.0f).method_60803(0xF000F0);
            buffer.method_22918(poseStack.method_23760().method_23761(), x1, 0.0f, z1).method_22915(r * brightness, g * brightness, b * brightness, bottomAlpha).method_22913(0.0f, v1).method_22914(0.0f, 1.0f, 0.0f).method_60803(0xF000F0);
            buffer.method_22918(poseStack.method_23760().method_23761(), x2, 0.0f, z2).method_22915(r * brightness, g * brightness, b * brightness, bottomAlpha).method_22913(1.0f, v1).method_22914(0.0f, 1.0f, 0.0f).method_60803(0xF000F0);
            buffer.method_22918(poseStack.method_23760().method_23761(), x2, 256.0f, z2).method_22915(r * brightness, g * brightness, b * brightness, topAlpha).method_22913(1.0f, v2).method_22914(0.0f, 1.0f, 0.0f).method_60803(0xF000F0);
        }
    }

    private static void renderNameTag(class_4587 poseStack, class_4597 consumers, class_243 camPos, double x, double y, double z, String name) {
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 2.5f, 0.0f);
        float yaw = class_310.method_1551().method_1561().field_4686.method_19330();
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotateY((float)Math.toRadians(-yaw)));
        double distance = camPos.method_1022(new class_243(x, y, z));
        float scale = 0.02f + (float)distance * 0.0015f;
        poseStack.method_22905(-scale, -scale, scale);
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727(name);
        font.method_27521(name, (float)(-textWidth) / 2.0f, -4.0f, 0xFFFFFF, false, poseStack.method_23760().method_23761(), consumers, class_327.class_6415.field_33993, 0, 0xF000F0);
        poseStack.method_22909();
    }
}

