/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.config;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.ashmeetop.feather_remake.client.config.SavedAccount;

public class AccountManager {
    private static final File FILE = new File("config/feather_remake/accounts.json");
    private static final Gson GSON = new Gson();
    private static List<SavedAccount> accounts = new ArrayList<SavedAccount>();

    public static void load() {
        try {
            if (FILE.exists()) {
                FileReader reader = new FileReader(FILE);
                Type type = new TypeToken<List<SavedAccount>>(){}.getType();
                accounts = (List)GSON.fromJson((Reader)reader, type);
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try {
            FILE.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(FILE);
            GSON.toJson(accounts, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<SavedAccount> getAccounts() {
        return accounts;
    }

    public static void addAccount(SavedAccount acc) {
        accounts.add(acc);
        AccountManager.save();
    }

    public static void removeAccount(SavedAccount acc) {
        accounts.remove(acc);
        AccountManager.save();
    }
}

