/*
 * Decompiled with CFR 0.152.
 */
package org.ashmeetop.feather_remake.client.gui.element;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

public class HueShiftedImage {
    private static final Map<String, class_2960> CACHE = new HashMap<String, class_2960>();
    private final class_2960 original;
    private float currentHue;

    public HueShiftedImage(class_2960 original, float initialHue) {
        this.original = original;
        this.currentHue = (initialHue % 1.0f + 1.0f) % 1.0f;
    }

    public class_2960 setHue(float hue) {
        this.currentHue = (hue % 1.0f + 1.0f) % 1.0f;
        return HueShiftedImage.shift(this.original, this.currentHue);
    }

    public class_2960 getShiftedTexture() {
        return HueShiftedImage.shift(this.original, this.currentHue);
    }

    public static void clearCache() {
        CACHE.clear();
    }

    public float getCurrentHue() {
        return this.currentHue;
    }

    private static class_2960 shift(class_2960 original, float hueShift) {
        class_2960 class_29602;
        block13: {
            if (Float.isNaN(hueShift) || Float.isInfinite(hueShift)) {
                return original;
            }
            String key = original.toString() + "_" + String.format("%.3f", Float.valueOf(hueShift));
            if (CACHE.containsKey(key)) {
                return CACHE.get(key);
            }
            InputStream inputStream = ((class_3298)class_310.method_1551().method_1478().method_14486(original).get()).method_14482();
            try {
                BufferedImage img = ImageIO.read(inputStream);
                int w = img.getWidth();
                int h = img.getHeight();
                class_1011 nativeImg = new class_1011(w, h, false);
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int argb = img.getRGB(x, y);
                        int a = argb >> 24 & 0xFF;
                        if (a == 0) {
                            nativeImg.method_4305(x, y, 0);
                            continue;
                        }
                        int r = argb >> 16 & 0xFF;
                        int g = argb >> 8 & 0xFF;
                        int b = argb & 0xFF;
                        float[] hsb = Color.RGBtoHSB(r, g, b, null);
                        float newHue = (hsb[0] + hueShift) % 1.0f;
                        int newRGB = Color.HSBtoRGB(newHue, hsb[1], hsb[2]);
                        int outR = newRGB >> 16 & 0xFF;
                        int outG = newRGB >> 8 & 0xFF;
                        int outB = newRGB & 0xFF;
                        int finalColor = a << 24 | outR << 16 | outG << 8 | outB;
                        nativeImg.method_4305(x, y, finalColor);
                    }
                }
                class_1043 dynTex = new class_1043(() -> key, nativeImg);
                class_2960 shifted = class_2960.method_60655((String)"hueshift", (String)(original.method_12832() + "_" + String.format("%.3f", Float.valueOf(hueShift)).replace(".", "_")));
                class_310.method_1551().method_1531().method_4616(shifted, (class_1044)dynTex);
                CACHE.put(key, shifted);
                class_29602 = shifted;
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return original;
                }
            }
            inputStream.close();
        }
        return class_29602;
    }
}

